/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.collections;

import ipsk.util.collections.BasicCollectionObserver;
import java.util.Collection;
import java.util.Iterator;

public abstract class ObservableCollection<E>
extends BasicCollectionObserver<E>
implements Collection<E> {
    protected Collection<E> collection;

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.collection.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.collection.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean changed = this.collection.add(e);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.collection.remove(o);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.collection.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = this.collection.addAll(c);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.collection.removeAll(c);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.collection.retainAll(c);
        if (changed) {
            this.fireCollectionChangedEvent();
        }
        return changed;
    }

    @Override
    public void clear() {
        boolean changed = !this.collection.isEmpty();
        this.collection.clear();
        if (changed) {
            this.fireCollectionChangedEvent();
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.collection.equals(o);
    }

    @Override
    public int hashCode() {
        return this.collection.hashCode();
    }
}

