/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.action.tree;

import ipsk.swing.action.tree.AbstractActionNode;
import ipsk.swing.action.tree.ActionLeaf;
import ipsk.util.LocalizableMessage;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import javax.swing.Icon;

public abstract class AbstractActionLeaf
extends AbstractActionNode
implements ActionLeaf {
    private HashMap<String, Object> propertyMap = new HashMap();
    private boolean enabled = true;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Icon icon;

    public AbstractActionLeaf(LocalizableMessage displayName) {
        super(displayName);
        if (displayName != null) {
            this.putValue("Name", displayName.localize());
        }
    }

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public Object getValue(String key) {
        return this.propertyMap.get(key);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void putValue(String key, Object value) {
        Object oldValue = this.propertyMap.get(key);
        this.propertyMap.put(key, value);
        if (value != null && !value.equals(oldValue) || oldValue != null) {
            this.propertyChangeSupport.firePropertyChange(key, oldValue, value);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean oldValue = this.enabled;
        this.enabled = enabled;
        if (this.enabled != oldValue) {
            this.propertyChangeSupport.firePropertyChange("enabled", oldValue, this.enabled);
        }
    }
}

