/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.collections;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class SetProxy<E>
implements Set<E> {
    protected boolean empty = true;
    protected ProxyState proxyState = ProxyState.UNAWARE;
    protected Set<E> set = new HashSet();
    protected Exception exception = null;

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected void setSet(Set<E> set) {
        this.set = set;
        this.empty = this.equals(set != null && set.size() != 0);
    }

    protected abstract ProxyState loadToProxyState(ProxyState var1);

    public void refresh() {
        this.proxyState = ProxyState.UNAWARE;
    }

    public void complete() {
        this.ensureProxyState(ProxyState.COMPLETE);
    }

    protected void ensureProxyState(ProxyState proxyState) {
        if (this.proxyState.compareTo(proxyState) < 0) {
            this.proxyState = this.loadToProxyState(proxyState);
        }
    }

    @Override
    public boolean add(E e) {
        this.ensureProxyState(ProxyState.LAZY);
        boolean added = this.set.add(e);
        this.setSet(this.set);
        return added;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.ensureProxyState(ProxyState.LAZY);
        boolean added = this.set.addAll(c);
        this.setSet(this.set);
        return added;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.setSet(this.set);
    }

    @Override
    public boolean contains(Object o) {
        this.ensureProxyState(ProxyState.LAZY);
        return this.set.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.ensureProxyState(ProxyState.LAZY);
        return this.set.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        this.ensureProxyState(ProxyState.EMPTINESS);
        return this.empty;
    }

    @Override
    public Iterator<E> iterator() {
        this.ensureProxyState(ProxyState.BASIC);
        return this.set.iterator();
    }

    @Override
    public boolean remove(Object o) {
        this.ensureProxyState(ProxyState.LAZY);
        boolean removed = this.set.remove(o);
        this.setSet(this.set);
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.ensureProxyState(ProxyState.LAZY);
        boolean removed = this.set.removeAll(c);
        this.setSet(this.set);
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.ensureProxyState(ProxyState.LAZY);
        boolean changed = this.set.retainAll(c);
        this.setSet(this.set);
        return changed;
    }

    @Override
    public int size() {
        this.ensureProxyState(ProxyState.SIZE);
        return this.set.size();
    }

    @Override
    public Object[] toArray() {
        this.ensureProxyState(ProxyState.BASIC);
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.ensureProxyState(ProxyState.BASIC);
        return this.set.toArray(a);
    }

    public static enum ProxyState {
        UNAWARE,
        EMPTINESS,
        SIZE,
        LAZY,
        BASIC,
        COMPLETE;

    }
}

