//    IPS Java Utils
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.sql;

/**
 * SQL/JPQL JOIN clause.
 * @author klausj
 *
 */
public class JoinClause {

	public static enum Type {INNER,LEFT,FETCH};
	
	private Type type;

	private String pathExpr;
	private String onClause=null;
	

	public JoinClause(Type type,String pathExpr){
		this(type,pathExpr,null);
	}
	
	public JoinClause(Type type,String pathExpr,String onClause){
		this.type=type;
		this.pathExpr=pathExpr;
		this.onClause=onClause;
	}
	
	public String getPathExpr() {
		return pathExpr;
	}

	public String toSQLString(){
		if (pathExpr==null) return "";
		String joinStr="";
		if(Type.INNER.equals(type)) {
			joinStr+="JOIN ";
		}else if(Type.LEFT.equals(type)) {
			joinStr+="LEFT JOIN ";
		}else if(Type.FETCH.equals(type)) {
			// makes only sense for JPQL queries
			joinStr+="JOIN ";
		}
		joinStr+=pathExpr;
		if(onClause!=null) {
			joinStr+=" ON "+onClause;
		}
			
		return joinStr;
	}
	
	public String toJPQLString(){
		if (pathExpr==null) return "";
		String joinStr="";
		if(Type.INNER.equals(type)) {
			joinStr+="JOIN ";
		}else if(Type.LEFT.equals(type)) {
			joinStr+="LEFT JOIN ";
		}else if(Type.FETCH.equals(type)) {
			joinStr+="JOIN FETCH";
		}
		joinStr+=pathExpr;
		if(onClause!=null) {
			joinStr+=" ON "+onClause;
		}
		return joinStr;
	}
	
}
