//    IPS Java Utils
//    (c) Copyright 2009-2011
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Utils
//
//
//    IPS Java Utils is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Utils is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Utils.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.swing;

import javax.swing.JScrollBar;



/**
 * A customized scroll bar.
 * This @see JScrollBar does neither change its value nor does it throw events if the knob is adjusting.
 * If the mouse is released the value is set and an @see javax.swing.AdjustmentEvent is thrown. 
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
public class JCustomScrollBar extends JScrollBar {
	private static final boolean DEBUG=false;
	
	private int extValue;
	/**
	 * 
	 */
	public JCustomScrollBar() {
		super();
	}

	/**
	 * @param orientation orientation
	 */
	public JCustomScrollBar(int orientation) {
		super(orientation);
	}

	/**
	 * @param orientation orientation
	 * @param value value
	 * @param extent extent
	 * @param min min
	 * @param max max
	 */
	public JCustomScrollBar(int orientation, int value, int extent, int min, int max) {
		super(orientation, value, extent, min, max);
	}

	protected void fireAdjustmentValueChanged(int id, int type, int value) {
		
		if (!getValueIsAdjusting()) {
			
			super.setValue(extValue);
			super.fireAdjustmentValueChanged(id, type, extValue);
		}
	}
	public void setValue(int v) {
		if (DEBUG) System.out.println("min: "+getMinimum()+" max: "+getMaximum()+" val: "+getValue());
		extValue=v;
		super.setValue(v);
		
	}
}
