/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

public class Complex {
    public double real;
    public double img;

    public Complex() {
        this.real = 0.0;
        this.img = 0.0;
    }

    public Complex(double real, double imaginary) {
        this.real = real;
        this.img = imaginary;
    }

    public static Complex fromPolarForm(double magnitude, double argument) {
        double r = Math.cos(argument) * magnitude;
        double i = Math.sin(argument) * magnitude;
        return new Complex(r, i);
    }

    public double magnitude() {
        return Math.sqrt(this.real * this.real + this.img * this.img);
    }

    public double argument() {
        return Math.atan2(this.img, this.real);
    }

    public Complex add(Complex addC) {
        return new Complex(this.real + addC.real, this.img + addC.img);
    }

    public Complex sub(Complex subC) {
        return new Complex(this.real - subC.real, this.img - subC.img);
    }

    public Complex mult(Complex multC) {
        double multR = this.real * multC.real - this.img * multC.img;
        double multI = this.real * multC.img + multC.real * this.img;
        return new Complex(multR, multI);
    }

    public Complex mult(double multF) {
        return new Complex(this.real * multF, this.img * multF);
    }

    public Complex div(Complex divisor) {
        double divReal = divisor.real;
        double divImg = divisor.img;
        double div = divReal * divReal + divImg * divImg;
        double divisionReal = (this.real * divReal + this.img * divImg) / div;
        double divisionImg = (divReal * this.img - this.real * divImg) / div;
        return new Complex(divisionReal, divisionImg);
    }

    public Complex div(double divisor) {
        double div = divisor * divisor;
        double divsionReal = this.real * divisor / div;
        double divsionImg = divisor * this.img / div;
        return new Complex(divsionReal, divsionImg);
    }

    public Complex conjugate() {
        return new Complex(this.real, -this.img);
    }

    public boolean equals(Complex c) {
        if (c == null) {
            return false;
        }
        return this.real == c.real && this.img == c.img;
    }

    public String toString() {
        return "Real: " + this.real + ", Img: " + this.img;
    }
}

