/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Complex;
import ipsk.math.DFTAlgorithm;

public class DFT
implements DFTAlgorithm {
    @Override
    public Complex[] process(Complex[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        for (int k = 0; k < sizeN; ++k) {
            Complex cx = new Complex();
            double argTmp = Math.PI * -2 * (double)k;
            for (int j = 0; j < sizeN; ++j) {
                Complex aj = srcBuf[j];
                double arg = argTmp * (double)j / (double)sizeN;
                Complex ec = new Complex(Math.cos(arg), Math.sin(arg));
                cx = cx.add(ec.mult(aj));
            }
            dstBuf[k] = cx;
        }
        return dstBuf;
    }

    public static Complex[] processInvers(Complex[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        for (int k = 0; k < sizeN; ++k) {
            Complex cx = new Complex();
            for (int j = 0; j < sizeN; ++j) {
                double arg = Math.PI * 2 * (double)k * (double)j / (double)sizeN;
                Complex aj = srcBuf[j];
                Complex ec = new Complex(Math.cos(arg), Math.sin(arg));
                cx = cx.add(ec.mult(aj));
            }
            dstBuf[k] = cx = cx.mult(1.0 / (double)sizeN);
        }
        return dstBuf;
    }

    @Override
    public Complex[] process(double[] srcBuf) {
        int sizeN = srcBuf.length;
        Complex[] dstBuf = new Complex[sizeN];
        for (int k = 0; k < sizeN; ++k) {
            Complex cx = new Complex();
            double tmpR = 0.0;
            double tmpI = 0.0;
            double argTmp = Math.PI * -2 * (double)k;
            for (int j = 0; j < sizeN; ++j) {
                double aj = srcBuf[j];
                double arg = argTmp * (double)j / (double)sizeN;
                tmpR += aj * Math.cos(arg);
                tmpI -= aj * Math.sin(arg);
            }
            cx.real = tmpR;
            cx.img = tmpI;
            dstBuf[k] = cx;
        }
        return dstBuf;
    }

    public Complex[] process(float[] srcBuf) {
        double[] srcDBuf = new double[srcBuf.length];
        for (int i = 0; i < srcBuf.length; ++i) {
            srcDBuf[i] = srcBuf[i];
        }
        return this.process(srcDBuf);
    }
}

