/*
 * Decompiled with CFR 0.152.
 */
package ips.dsp;

public class AutoCorrelator {
    public static AutoCorrelationResult autoCorrelate(double[] buf, int offset, int corrLen, int corrStart, int corrEnd) {
        int corrIvLen = corrEnd - corrStart;
        double sum0 = 0.0;
        int pos = offset;
        for (int i = 0; i < corrLen; ++i) {
            sum0 += buf[pos] * buf[pos];
            ++pos;
        }
        double max = 0.0;
        int maxPosOff = 0;
        for (int p = 0; p < corrIvLen; ++p) {
            double val = 0.0;
            pos = offset;
            int pos2 = offset + corrStart + p;
            for (int i = 0; i < corrLen; ++i) {
                val += buf[pos] * buf[pos2];
                ++pos;
                ++pos2;
            }
            if (!(val > max)) continue;
            max = val;
            maxPosOff = p;
        }
        AutoCorrelationResult rs = new AutoCorrelationResult(sum0 / (double)corrLen, maxPosOff, max / (double)corrLen);
        return rs;
    }

    public static double[] autoCorrelate(double[] buf) {
        int corrLen = buf.length;
        double[] corr = new double[corrLen];
        for (int p = 0; p < corrLen; ++p) {
            double val = 0.0;
            for (int i = 0; i < corrLen; ++i) {
                int pos = p + i;
                if (pos >= corrLen) continue;
                val += buf[pos] * buf[i];
            }
            corr[p] = val;
        }
        return corr;
    }

    public static void main(String[] args) {
        double[] fcs = AutoCorrelator.autoCorrelate(new double[]{2.0, 4.0, 0.3});
        for (int i = 0; i < fcs.length; ++i) {
            System.out.println(fcs[i]);
        }
    }

    public static class AutoCorrelationResult {
        private double energy;
        private int positionMax;
        private double corrEnergyMax;

        public double getEnergy() {
            return this.energy;
        }

        public int getPositionMax() {
            return this.positionMax;
        }

        public double getCorrEnergyMax() {
            return this.corrEnergyMax;
        }

        public double correlation() {
            return this.corrEnergyMax / this.energy;
        }

        public AutoCorrelationResult(double energy, int positionMax, double energyMax) {
            this.energy = energy;
            this.positionMax = positionMax;
            this.corrEnergyMax = energyMax;
        }
    }
}

