/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.swing.filemanager;

import ips.incubator.swing.filemanager.JFileView;
import java.awt.Desktop;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;

public class JDirectoryView
extends JPanel
implements MouseListener {
    private File directory;
    private File[] childs;
    private JFileView[] fileViews;
    private int cols = 6;
    private int rows;
    public static final int DEFAULT_COLUMNS = 6;

    public JDirectoryView() {
        super(new GridLayout(0, 4));
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
        this.removeAll();
        this.childs = directory.listFiles();
        int childCount = this.childs.length;
        this.rows = childCount / this.cols;
        if (childCount % this.cols > 0) {
            ++this.rows;
        }
        this.fileViews = new JFileView[childCount];
        for (int i = 0; i < childCount; ++i) {
            JFileView fileView = new JFileView(this.childs[i]);
            fileView.addMouseListener(this);
            this.fileViews[i] = fileView;
            this.add(this.fileViews[i]);
        }
        this.revalidate();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object src = e.getSource();
        for (JFileView jfv : this.fileViews) {
            if (!jfv.equals(src)) continue;
            File f = jfv.getFile();
            if (f.isDirectory()) {
                this.setDirectory(f);
                continue;
            }
            try {
                Desktop.getDesktop().open(f);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

