/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class TitledPanel
extends JPanel {
    private Border baseBorder;
    private Border border;
    private String title = null;
    private boolean enabled = true;

    public TitledPanel() {
        this("");
    }

    public TitledPanel(String title) {
        this.baseBorder = BorderFactory.createLoweredBevelBorder();
        this.setTitle(title);
    }

    public TitledPanel(Border baseBorder, String title) {
        this.baseBorder = baseBorder;
        this.setTitle(title);
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.border instanceof TitledBorder) {
            if (title != null) {
                ((TitledBorder)this.border).setTitle(title);
            } else {
                this.border = this.baseBorder;
                this.setBorder(this.border);
            }
        } else if (title != null) {
            this.border = BorderFactory.createTitledBorder(this.baseBorder, title);
            this.setBorder(this.border);
        }
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Color titleColor = enabled ? this.getForeground() : UIManager.getColor("Label.disabledForeground");
        if (this.border instanceof TitledBorder) {
            ((TitledBorder)this.border).setTitleColor(titleColor);
        }
        this.repaint();
    }
}

