/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.action.tree;

import ipsk.swing.action.tree.AbstractActionNode;
import ipsk.swing.action.tree.ActionLeaf;
import ipsk.swing.action.tree.ActionNode;
import ipsk.util.LocalizableMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ActionList
extends AbstractActionNode {
    protected String key;
    private List<ActionNode> children = new ArrayList<ActionNode>();

    public ActionList(String key) {
        this.key = key;
    }

    public ActionList(String key, LocalizableMessage displayName) {
        super(displayName);
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public LocalizableMessage getDisplayName() {
        LocalizableMessage dn = super.getDisplayName();
        if (dn == null) {
            dn = new LocalizableMessage(this.key);
        }
        return dn;
    }

    public ActionList deepClone() {
        ActionList dClone = new ActionList(this.key);
        for (ActionNode an : this.getChildren()) {
            if (an instanceof ActionList) {
                ActionList chAf = (ActionList)an;
                ActionList cdClone = chAf.deepClone();
                dClone.getChildren().add(cdClone);
                continue;
            }
            if (!(an instanceof ActionLeaf)) continue;
            dClone.getChildren().add(an);
        }
        return dClone;
    }

    public void merge(ActionList merge) {
        if (merge != null) {
            List<ActionNode> chs = this.getChildren();
            List<ActionNode> mChs = merge.getChildren();
            for (ActionNode mCh : mChs) {
                boolean merged = false;
                if (mCh instanceof ActionList) {
                    ActionList mAf = (ActionList)mCh;
                    for (ActionNode ch : chs) {
                        if (!mCh.equals(ch)) continue;
                        ActionList af = (ActionList)ch;
                        af.merge(mAf);
                        merged = true;
                        break;
                    }
                    if (merged) continue;
                    this.getChildren().add(mAf);
                    continue;
                }
                for (ActionNode ch : chs) {
                    if (!mCh.equals(ch)) continue;
                    merged = true;
                    break;
                }
                if (merged) continue;
                this.getChildren().add(mCh);
            }
        }
    }

    public ActionList copymerge(ActionList merge) {
        ActionList copy = this.deepClone();
        if (merge != null) {
            copy.merge(merge);
        }
        return copy;
    }

    public boolean add(ActionNode arg0) {
        return this.children.add(arg0);
    }

    public void add(int arg0, ActionNode arg1) {
        this.children.add(arg0, arg1);
    }

    public boolean addAll(Collection<? extends ActionNode> arg0) {
        return this.children.addAll(arg0);
    }

    public boolean addAll(int arg0, Collection<? extends ActionNode> arg1) {
        return this.children.addAll(arg0, arg1);
    }

    public void clear() {
        this.children.clear();
    }

    public boolean contains(Object arg0) {
        return this.children.contains(arg0);
    }

    public boolean containsAll(Collection<?> arg0) {
        return this.children.containsAll(arg0);
    }

    public ActionNode get(int arg0) {
        return this.children.get(arg0);
    }

    public boolean remove(Object arg0) {
        return this.children.remove(arg0);
    }

    public boolean removeAll(Collection<?> arg0) {
        return this.children.removeAll(arg0);
    }

    public ActionNode set(int arg0, ActionNode arg1) {
        return this.children.set(arg0, arg1);
    }

    public int size() {
        return this.children.size();
    }

    public List<ActionNode> subList(int arg0, int arg1) {
        return this.children.subList(arg0, arg1);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActionList)) {
            return false;
        }
        ActionList oAF = (ActionList)o;
        if (this.key == null) {
            return false;
        }
        return this.key.equals(oAF.getKey());
    }

    public List<ActionNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ActionNode> children) {
        this.children = children;
    }

    @Override
    public String toString() {
        return "Action list: key: " + this.key + " ," + super.toString();
    }
}

