/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.swing;

import ipsk.awt.GridTick;
import ipsk.awt.JScale;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class JAutoScale2
extends JScale<BigDecimal> {
    private static final long serialVersionUID = 1L;
    private static final int DEBUG = 1;
    private static final double DEFAULT_BASE = 10.0;
    private static final double[] DEFAULT_DIVIDERS = new double[]{2.0, 5.0};
    private static final double DEFAULT_AXIS_PADDING_FACTOR = 1.2;
    private static final double DEFAULT_NOAXIS_PADDING_FACTOR = 1.1;
    private int width;
    private int height;
    private int minWidth = 0;
    private int minHeight = 0;
    private double horizontalPaddingFactor;
    private double verticalPaddingFactor;
    private Format labelFormat;
    private int lineLength;
    private int halfLineLength;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private BigDecimal scaleBegin;
    private BigDecimal scaleEnd;
    private BigDecimal bDdelta;
    private double delta;
    private double base;
    private double[] dividers;
    private Dimension maxLabelSize = new Dimension();
    private int maxNumTicks;
    private BigDecimal majTick;
    private BigDecimal firstTickValue;
    private boolean normalizeLabelScales = true;
    private volatile Dimension layoutForSize = null;

    public JAutoScale2() {
        this(JScale.Orientation.SOUTH, new BigDecimal(0), new BigDecimal(0));
    }

    public JAutoScale2(JScale.Orientation orientation, BigDecimal from, BigDecimal to) {
        this(orientation, 0, from, to);
    }

    public JAutoScale2(JScale.Orientation orientation, int length, BigDecimal d, BigDecimal e) {
        super(orientation);
        this.setLayout(null);
        if (this.normalizeLabelScales) {
            this.scaleBegin = d.stripTrailingZeros();
            this.scaleEnd = e.stripTrailingZeros();
        } else {
            this.scaleBegin = d;
            this.scaleEnd = e;
        }
        this.bDdelta = e.subtract(d);
        this.delta = this.bDdelta.doubleValue();
        this.base = 10.0;
        this.dividers = DEFAULT_DIVIDERS;
        if (JScale.Orientation.SOUTH.equals((Object)orientation)) {
            this.horizontalPaddingFactor = 1.2;
            this.verticalPaddingFactor = 1.1;
            this.minWidth = length;
        } else if (JScale.Orientation.WEST.equals((Object)orientation)) {
            this.horizontalPaddingFactor = 1.1;
            this.verticalPaddingFactor = 1.2;
            this.minHeight = length;
        }
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.rescale();
    }

    private String format(Number tickValue) {
        if (this.labelFormat == null) {
            return tickValue.toString();
        }
        return this.labelFormat.format(tickValue);
    }

    protected BigDecimal[] computeExampleTicks() {
        int minNumExampleTicks = 4;
        double minTick = this.delta / (double)minNumExampleTicks;
        double minTickAbs = Math.abs(minTick);
        double minTickPow = Math.log(minTickAbs) / Math.log(this.base);
        int tickPow = (int)Math.ceil(minTickPow);
        BigDecimal majTickAbs = BigDecimal.valueOf(1L, -tickPow);
        for (int i = 0; i < this.dividers.length; ++i) {
            BigDecimal division = majTickAbs.divide(new BigDecimal(this.dividers[i]));
            double divisionD = division.doubleValue();
            if (!(divisionD > minTickAbs)) continue;
            majTickAbs = division;
        }
        BigDecimal majTick = this.delta >= 0.0 ? majTickAbs : majTickAbs.multiply(new BigDecimal(-1));
        majTick = majTick.stripTrailingZeros();
        System.out.println("Chosen majTick: " + majTick);
        BigDecimal firstTickValue = null;
        BigDecimal nextTickValue = null;
        BigDecimal preLastTickValue = null;
        BigDecimal lastTickValue = null;
        BigDecimal[] samples = new BigDecimal[4];
        if (majTickAbs.signum() > 0) {
            BigDecimal firstTickUnits = this.scaleBegin.divideToIntegralValue(majTickAbs);
            if (this.bDdelta.signum() < 0) {
                firstTickUnits.add(BigDecimal.ONE);
            }
            firstTickValue = firstTickUnits.multiply(majTickAbs).stripTrailingZeros();
            nextTickValue = firstTickValue.add(majTick).stripTrailingZeros();
            preLastTickValue = firstTickValue.add(majTick.multiply(new BigDecimal(minNumExampleTicks - 1))).stripTrailingZeros();
            lastTickValue = firstTickValue.add(majTick.multiply(new BigDecimal(minNumExampleTicks))).stripTrailingZeros();
        }
        samples[0] = firstTickValue;
        samples[1] = nextTickValue;
        samples[2] = preLastTickValue;
        samples[3] = lastTickValue;
        if (this.normalizeLabelScales) {
            int requiredScale = Integer.MIN_VALUE;
            for (BigDecimal s : samples) {
                int sScale;
                if (s == null || (sScale = s.scale()) <= requiredScale) continue;
                requiredScale = sScale;
            }
            BigDecimal[] scaledSamples = new BigDecimal[samples.length];
            for (int i = 0; i < samples.length; ++i) {
                BigDecimal s = samples[i];
                if (s == null) continue;
                scaledSamples[i] = s.setScale(requiredScale);
            }
            samples = scaledSamples;
        }
        return samples;
    }

    private void computeTicks() {
        Dimension d = this.getSize();
        this.computeExampleTicks();
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            this.maxNumTicks = (int)((double)d.width / ((double)this.maxLabelSize.width * this.horizontalPaddingFactor));
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            this.maxNumTicks = (int)((double)d.height / ((double)this.maxLabelSize.height * this.verticalPaddingFactor));
        }
        double minTick = this.delta / (double)this.maxNumTicks;
        double minTickAbs = Math.abs(minTick);
        double minTickPow = Math.log(minTickAbs) / Math.log(this.base);
        int tickPow = (int)Math.ceil(minTickPow);
        BigDecimal bdBase = new BigDecimal(10);
        BigDecimal majTickAbs = BigDecimal.valueOf(1L, -tickPow);
        for (int i = 0; i < this.dividers.length; ++i) {
            BigDecimal division = majTickAbs.divide(new BigDecimal(this.dividers[i]));
            double divisionD = division.doubleValue();
            if (!(divisionD > minTickAbs)) continue;
            majTickAbs = division;
        }
        this.majTick = this.delta >= 0.0 ? majTickAbs : majTickAbs.multiply(new BigDecimal(-1));
        this.majTick = this.majTick.stripTrailingZeros();
        System.out.println("Chosen real majTick: " + this.majTick);
        if (majTickAbs.signum() > 0) {
            BigDecimal firstTickUnits = this.scaleBegin.divideToIntegralValue(majTickAbs);
            if (this.bDdelta.signum() < 0) {
                firstTickUnits.add(BigDecimal.ONE);
            }
            this.firstTickValue = firstTickUnits.multiply(majTickAbs);
        } else {
            this.firstTickValue = this.scaleBegin;
        }
        this.firstTickValue = this.firstTickValue.stripTrailingZeros();
    }

    @Override
    protected void paintComponent(Graphics g) {
        block20: {
            GridTick<BigDecimal>[] ticks;
            int lineX1;
            Rectangle a;
            block19: {
                GridTick<BigDecimal>[] ticks2;
                super.paintComponent(g);
                if (this.isEnabled()) {
                    g.setColor(this.getForeground());
                } else {
                    g.setColor(this.getBackground().darker());
                }
                a = g.getClipBounds();
                this.width = this.getWidth();
                this.height = this.getHeight();
                if (this.width == 0 || this.height == 0) {
                    return;
                }
                lineX1 = 0;
                int lineX2 = 0;
                int lineY1 = 0;
                int lineY2 = 0;
                if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
                    lineX1 = a.x;
                    lineX2 = a.x + a.width;
                    lineY2 = lineY1 = this.height - this.getMinimumSizeFromMaxLabelSize((Dimension)this.maxLabelSize).height;
                } else if (JScale.Orientation.NORTH.equals((Object)this.orientation)) {
                    lineX1 = a.x;
                    lineX2 = a.x + a.width;
                    lineY2 = lineY1 = 1;
                } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
                    lineX2 = lineX1 = this.getMinimumSizeFromMaxLabelSize((Dimension)this.maxLabelSize).width - 1;
                    lineY1 = a.y;
                    lineY2 = a.y + a.height;
                } else if (JScale.Orientation.EAST.equals((Object)this.orientation)) {
                    lineX2 = lineX1 = 1;
                    lineY1 = a.y;
                    lineY2 = a.y + a.height;
                }
                g.setColor(this.getBackground());
                g.fillRect(lineX1, lineY1, this.width, this.height);
                g.setColor(this.getForeground());
                g.drawLine(lineX1, lineY1, lineX2, lineY2);
                if (!JScale.Orientation.SOUTH.equals((Object)this.orientation)) break block19;
                for (GridTick<BigDecimal> gt : ticks2 = this.getScaleTicks(a.x, a.x + a.width)) {
                    int pos = gt.getPosition();
                    BigDecimal tv = gt.getTickValue();
                    Dimension tvDim = this.getLabelSize(tv);
                    if (tvDim != null) {
                        if (tvDim.width > this.maxLabelSize.width) {
                            this.maxLabelSize.width = tvDim.width;
                            this.layoutForSize = this.getSize();
                            this.revalidate();
                            this.repaint();
                            return;
                        }
                        if (tvDim.height > this.maxLabelSize.height) {
                            this.maxLabelSize.height = tvDim.height;
                            this.layoutForSize = this.getSize();
                            this.revalidate();
                            this.repaint();
                            return;
                        }
                    }
                    g.drawString(this.format(gt.getTickValue()), pos + 1, lineY1 + this.maxLabelSize.height + this.halfLineLength);
                    g.drawLine(pos, 0, pos, lineY1 + this.lineLength);
                    int halfPos = pos + (gt.getNextPosition() - pos) / 2;
                    g.drawLine(halfPos, lineY1, halfPos, lineY1 + this.halfLineLength);
                }
                break block20;
            }
            if (!JScale.Orientation.WEST.equals((Object)this.orientation)) break block20;
            for (GridTick<BigDecimal> gt : ticks = this.getScaleTicks(a.y, a.y + a.height)) {
                int pos = gt.getPosition();
                BigDecimal tv = gt.getTickValue();
                Dimension tvDim = this.getLabelSize(tv);
                if (tvDim != null) {
                    if (tvDim.width > this.maxLabelSize.width) {
                        this.maxLabelSize.width = tvDim.width;
                        this.layoutForSize = this.getSize();
                        this.revalidate();
                        this.repaint();
                    } else if (tvDim.height > this.maxLabelSize.height) {
                        this.maxLabelSize.height = tvDim.height;
                        this.layoutForSize = this.getSize();
                        this.revalidate();
                        this.repaint();
                    }
                }
                g.drawString(this.format(gt.getTickValue()), lineX1 - this.maxLabelSize.width - this.halfLineLength, pos + this.maxLabelSize.height);
                g.drawLine(lineX1, pos, lineX1 - this.lineLength, pos);
                int halfPos = pos + (gt.getNextPosition() - pos) / 2;
                g.drawLine(lineX1, halfPos, lineX1 - this.halfLineLength, halfPos);
            }
        }
    }

    public GridTick<BigDecimal>[] getScaleTicks(int fromPixel, int toPixel) {
        GridTick<BigDecimal> newTick;
        int nextPos;
        int pos;
        double areaEndValue;
        BigDecimal tickValue;
        BigDecimal areaBegValue;
        double d;
        this.computeTicks();
        ArrayList<GridTick<BigDecimal>> gridTicks = new ArrayList<GridTick<BigDecimal>>();
        double dDelta = this.delta;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            double dWidth = this.width;
            d = fromPixel;
            areaBegValue = this.scaleBegin.add(new BigDecimal(d * dDelta / dWidth));
            tickValue = BigDecimal.ZERO;
            if (!this.majTick.equals(BigDecimal.ZERO)) {
                tickValue = this.firstTickValue;
                areaEndValue = this.scaleBegin.doubleValue() + (d + (double)(toPixel - fromPixel)) * dDelta / dWidth;
                do {
                    pos = (int)(tickValue.subtract(this.scaleBegin).doubleValue() / dDelta * dWidth);
                    nextPos = (int)(tickValue.add(this.majTick).subtract(this.scaleBegin).doubleValue() / dDelta * dWidth);
                    newTick = new GridTick<BigDecimal>(pos, tickValue);
                    newTick.setNextPosition(nextPos);
                    gridTicks.add(newTick);
                    tickValue = tickValue.add(this.majTick);
                } while (this.majTick.signum() > 0 && tickValue.doubleValue() <= areaEndValue || this.majTick.signum() < 0 && tickValue.doubleValue() >= areaEndValue);
            }
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            double dHeight = this.height;
            d = fromPixel;
            areaBegValue = this.scaleBegin.add(new BigDecimal(d * dDelta / dHeight));
            tickValue = BigDecimal.ZERO;
            if (!this.majTick.equals(BigDecimal.ZERO)) {
                tickValue = this.firstTickValue;
                areaEndValue = this.scaleBegin.doubleValue() + (d + (double)(toPixel - fromPixel)) * dDelta / dHeight;
                do {
                    pos = (int)(tickValue.subtract(this.scaleBegin).doubleValue() / dDelta * dHeight);
                    nextPos = (int)(tickValue.add(this.majTick).subtract(this.scaleBegin).doubleValue() / dDelta * dHeight);
                    newTick = new GridTick<BigDecimal>(pos, tickValue);
                    newTick.setNextPosition(nextPos);
                    gridTicks.add(newTick);
                    tickValue = tickValue.add(this.majTick);
                } while (this.majTick.signum() > 0 && tickValue.doubleValue() <= areaEndValue || this.majTick.signum() < 0 && tickValue.doubleValue() >= areaEndValue);
            }
        }
        if (this.normalizeLabelScales) {
            BigDecimal gtVal;
            int requiredScale = Integer.MIN_VALUE;
            for (GridTick gridTick : gridTicks) {
                gtVal = ((BigDecimal)gridTick.getTickValue()).stripTrailingZeros();
                int valScale = gtVal.scale();
                if (valScale <= requiredScale) continue;
                requiredScale = valScale;
            }
            for (GridTick gridTick : gridTicks) {
                gtVal = (BigDecimal)gridTick.getTickValue();
                BigDecimal gtScaledval = gtVal.setScale(requiredScale);
                gridTick.setTickValue(gtScaledval);
            }
        }
        GridTick[] emptyArray = new GridTick[]{};
        GridTick[] array = gridTicks.toArray(emptyArray);
        return array;
    }

    public double getVerticalPaddingFactor() {
        return this.verticalPaddingFactor;
    }

    public void setVerticalPaddingFactor(double d) {
        this.verticalPaddingFactor = d;
        this.rescale();
    }

    public double getHorizontalPaddingFactor() {
        return this.horizontalPaddingFactor;
    }

    public void setHorizontalPaddingFactor(double d) {
        this.horizontalPaddingFactor = d;
        this.rescale();
    }

    private Dimension getLabelSize(BigDecimal val) {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fontMetrics = this.getFontMetrics(f);
            Rectangle2D valBounds = fontMetrics.getStringBounds(this.format(val), this.getGraphics());
            double valWidth = valBounds.getWidth();
            double valHeight = valBounds.getHeight();
            Dimension d = new Dimension();
            d.setSize(valWidth, valHeight);
            return d;
        }
        return null;
    }

    protected void calcMaxLabelSize() {
        BigDecimal[] exampleTickValues = this.computeExampleTicks();
        int maxLabelWidth = 0;
        int maxLabelHeight = 0;
        for (BigDecimal exampleTickVal : exampleTickValues) {
            Dimension exampleValueDim = this.getLabelSize(exampleTickVal);
            if (exampleValueDim == null) continue;
            if (exampleValueDim.width > maxLabelWidth) {
                maxLabelWidth = exampleValueDim.width;
            }
            if (exampleValueDim.height <= maxLabelHeight) continue;
            maxLabelHeight = exampleValueDim.height;
        }
        this.maxLabelSize = new Dimension(maxLabelWidth, maxLabelHeight);
    }

    protected void calcMaxLabelSize(int length) {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fontMetrics = this.getFontMetrics(f);
            Rectangle2D fromBounds = fontMetrics.getStringBounds(this.format(this.scaleBegin), this.getGraphics());
            Rectangle2D toBounds = fontMetrics.getStringBounds(this.format(this.scaleEnd), this.getGraphics());
            double fromWidth = fromBounds.getWidth();
            double toWidth = toBounds.getWidth();
            double fromHeight = fromBounds.getHeight();
            double toHeight = toBounds.getHeight();
            double maxLabelWidth = Math.max(fromWidth, toWidth);
            double maxLabelHeight = Math.max(fromHeight, toHeight);
            Dimension d = new Dimension();
            d.setSize(maxLabelWidth, maxLabelHeight);
            this.maxLabelSize = d;
        }
    }

    private Dimension getMinimumSizeFromMaxLabelSize(Dimension maxLabelSize) {
        double paddedLabelWidth = (double)maxLabelSize.width * this.horizontalPaddingFactor;
        double paddedLabelHeight = (double)maxLabelSize.height * this.verticalPaddingFactor;
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            this.lineLength = maxLabelSize.height;
            this.halfLineLength = this.lineLength / 2;
            this.minHeight = (int)paddedLabelHeight + 2 + this.halfLineLength;
            this.minWidth = 0;
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            this.lineLength = maxLabelSize.height;
            this.halfLineLength = this.lineLength / 2;
            this.minWidth = (int)paddedLabelWidth + 2 + this.halfLineLength;
            this.minHeight = 0;
        }
        return new Dimension(this.minWidth, this.minHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension currSize = this.getSize();
        if (this.layoutForSize == null || !this.layoutForSize.equals(currSize)) {
            this.calcMaxLabelSize();
        }
        Dimension minSize = this.getMinimumSizeFromMaxLabelSize(this.maxLabelSize);
        return minSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Format getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(Format format) {
        this.labelFormat = format;
        this.rescale();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.rescale();
    }

    private void rescale() {
        this.revalidate();
        this.repaint();
    }

    public BigDecimal getScaleBegin() {
        return this.scaleBegin;
    }

    public void setScaleBegin(BigDecimal scaleBegin) {
        this.scaleBegin = scaleBegin;
        this.rescale();
    }

    public BigDecimal getScaleEnd() {
        return this.scaleEnd;
    }

    public void setScaleEnd(BigDecimal scaleEnd) {
        this.scaleEnd = scaleEnd;
        this.rescale();
    }

    @Override
    public synchronized void setOrientation(JScale.Orientation orientation) {
        if (this.orientation.equals((Object)orientation)) {
            return;
        }
        super.setOrientation(orientation);
        int tmp1 = this.minWidth;
        this.minWidth = this.minHeight;
        this.minHeight = tmp1;
        double tmp2 = this.horizontalPaddingFactor;
        this.horizontalPaddingFactor = this.verticalPaddingFactor;
        this.verticalPaddingFactor = tmp2;
        this.rescale();
    }

    @Override
    public void doLayout() {
        if (this.layoutForSize != null) {
            Dimension currSize = this.getSize();
            if (!this.layoutForSize.equals(currSize)) {
                this.layoutForSize = null;
                this.calcMaxLabelSize();
            }
        } else {
            this.calcMaxLabelSize();
        }
        this.bDdelta = this.scaleEnd.subtract(this.scaleBegin);
        this.delta = this.bDdelta.doubleValue();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BigDecimal[] samples;
                double test = 0.1;
                BigDecimal bd = BigDecimal.valueOf(1L, 1);
                BigDecimal bd2 = bd.multiply(new BigDecimal(7));
                BigDecimal bd3 = BigDecimal.valueOf(-65432L, 10);
                BigDecimal s1 = BigDecimal.valueOf(-10L, 1);
                BigDecimal s2 = s1.stripTrailingZeros();
                for (int i = 0; i < 20; ++i) {
                }
                JAutoScale2 jasVer = new JAutoScale2(JScale.Orientation.SOUTH, 800, BigDecimal.valueOf(-130002L, 5), BigDecimal.valueOf(1L, 0));
                for (BigDecimal s : samples = jasVer.computeExampleTicks()) {
                    System.out.println("sample: " + s);
                }
                Dimension pSize = new Dimension(200, 600);
                jasVer.setSize(pSize);
                jasVer.setPreferredSize(pSize);
                JFrame testFrameVer = new JFrame(jasVer.getClass().getName() + " Test Vertical");
                testFrameVer.setDefaultCloseOperation(3);
                testFrameVer.getContentPane().add(jasVer);
                testFrameVer.getContentPane().setSize(pSize);
                testFrameVer.getContentPane().setPreferredSize(pSize);
                testFrameVer.pack();
                testFrameVer.setVisible(true);
            }
        });
    }

    public class Size
    extends Dimension2D {
        private double width;
        private double height;

        public Size(double width, double height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public void setSize(double arg0, double arg1) {
            this.width = arg0;
            this.height = arg1;
        }

        @Override
        public Object clone() {
            return new Size(this.width, this.height);
        }
    }
}

