/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.util;

import ipsk.util.RadixConverters;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.UUID;

public class UUIDGenerator {
    public UUID createUUID(byte[] macAddr) {
        UUID rUUID = UUID.randomUUID();
        long lsbs = rUUID.getLeastSignificantBits();
        long msbs = rUUID.getMostSignificantBits();
        long macAddrLong = 0L;
        System.out.println("Version: " + rUUID.version());
        return rUUID;
    }

    public byte[] getHardwareAdress() throws SocketException {
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            byte[] macAddr = nif.getHardwareAddress();
            String nifName = nif.getName();
            String macAddrHex = null;
            if (macAddr == null) continue;
            macAddrHex = RadixConverters.bytesToHex(macAddr);
            System.out.println(nifName + " " + nif.isLoopback() + " " + macAddrHex);
            return macAddr;
        }
        return null;
    }

    public static void main(String[] args) {
        UUIDGenerator uuidGen = new UUIDGenerator();
        try {
            UUID uuid = uuidGen.createUUID(uuidGen.getHardwareAdress());
            System.out.println(uuid);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }
}

