/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.util.LocalizableMessage;

public class FilenameValidator {
    public static String[] RESERVED_NAMES = new String[]{".", ".."};
    public static char[] RESERVED_CHARS_WINDOWS = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*'};
    public static String[] RESERVED_NAMES_WINDOWS = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
    public static char[] RESERVED_CHARS_UNIX = new char[]{'\u0000', '/'};

    public static ValidationResult validateFileNameCharacters(String string) {
        char[] fileNameChars;
        for (char fnc : fileNameChars = string.toCharArray()) {
            for (char rc : RESERVED_CHARS_WINDOWS) {
                if (rc != fnc) continue;
                return new ValidationResult("contains reserved character: \"" + rc + "\"");
            }
            for (char rc : RESERVED_CHARS_UNIX) {
                if (rc != fnc) continue;
                return new ValidationResult("contains reserved character: \"" + rc + "\"");
            }
            if (!Character.isISOControl(fnc)) continue;
        }
        return new ValidationResult(true);
    }

    public static ValidationResult validate(String fileName) {
        if (fileName == null) {
            throw new NullPointerException();
        }
        for (String string : RESERVED_NAMES) {
            if (!fileName.equals(string)) continue;
            return new ValidationResult("reserved name: " + fileName);
        }
        ValidationResult vrc = FilenameValidator.validateFileNameCharacters(fileName);
        if (!vrc.isValid()) {
            return vrc;
        }
        String fileNameBody = fileName;
        int extPos = fileName.lastIndexOf(".");
        if (extPos > 0) {
            fileNameBody = fileName.substring(0, extPos);
        }
        for (String resNameWindows : RESERVED_NAMES_WINDOWS) {
            if (!fileNameBody.equals(resNameWindows)) continue;
            return new ValidationResult("reserved Windows filename: " + resNameWindows);
        }
        char c = fileName.charAt(fileName.length() - 1);
        if (c == ' ' || c == '.') {
            return new ValidationResult("on Windows last char of filename should not be a space or period");
        }
        return new ValidationResult(true);
    }

    public static class ValidationResult {
        private LocalizableMessage message;
        private boolean valid;

        public ValidationResult(boolean valid) {
            this(valid, null);
        }

        public ValidationResult(String message) {
            this(false, new LocalizableMessage(message));
        }

        public ValidationResult(boolean valid, LocalizableMessage message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public LocalizableMessage getMessage() {
            return this.message;
        }

        public static enum Type {
            OK,
            VALID_NOT_RECOMMENDED,
            INVALID;

        }
    }
}

