/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math;

import ipsk.math.Window;

public class GaussianWindow
implements Window {
    public static double DEFAULT_SIGMA = 0.3;
    private double[] buf;

    public GaussianWindow(int size) {
        this(size, DEFAULT_SIGMA);
    }

    public GaussianWindow(int size, double sigma) {
        this.buf = new double[size];
        double center = (size - 1) / 2;
        for (int i = 0; i < size; ++i) {
            double val;
            double quot = ((double)i - center) / (sigma * center);
            double exp = -0.5 * quot * quot;
            this.buf[i] = val = Math.exp(exp);
        }
    }

    @Override
    public double getScale(int i) {
        return this.buf[i];
    }
}

