/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JLocaleSelector
extends JPanel {
    private static final long serialVersionUID = -5022947991427905196L;
    private JComboBox<LocaleView> languageSelector;
    private Vector<LocaleView> localeViews;

    public JLocaleSelector() {
        Locale[] locales = Locale.getAvailableLocales();
        this.localeViews = new Vector();
        for (Locale l : locales) {
            if (Locale.ROOT.equals(l)) continue;
            this.localeViews.add(new LocaleView(l));
        }
        Collections.sort(this.localeViews);
        this.localeViews.insertElementAt(new LocaleView(null), 0);
        this.languageSelector = new JComboBox<LocaleView>(this.localeViews);
        this.add(this.languageSelector);
    }

    public Locale getSelectedLocale() {
        Locale retLoc = null;
        Object lv = this.languageSelector.getSelectedItem();
        if (lv instanceof LocaleView) {
            retLoc = ((LocaleView)lv).getLocale();
        }
        return retLoc;
    }

    public void setSelectedLocale(Locale locale) {
        LocaleView lv = new LocaleView(locale);
        this.languageSelector.setSelectedItem(lv);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.languageSelector.setEnabled(enabled);
    }

    public static void main(String[] args) {
        Runnable uiRun = new Runnable(){

            @Override
            public void run() {
                JLocaleSelector ls = new JLocaleSelector();
                JFrame f = new JFrame("JLocalSelector Demo");
                f.getContentPane().add(ls);
                f.pack();
                f.setVisible(true);
            }
        };
        try {
            SwingUtilities.invokeAndWait(uiRun);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public class LocaleView
    implements Comparable<LocaleView> {
        private Locale locale;

        public LocaleView(Locale locale) {
            this.locale = locale;
        }

        public String toString() {
            if (this.locale == null) {
                return "--Language,Country--";
            }
            return this.locale.getDisplayName();
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof LocaleView) {
                LocaleView oLv = (LocaleView)obj;
                Locale oLo = oLv.getLocale();
                if (this.locale == null) {
                    return oLo == null;
                }
                return this.locale.equals(oLo);
            }
            return false;
        }

        public int hashCode() {
            return this.locale.hashCode();
        }

        @Override
        public int compareTo(LocaleView o) {
            return this.toString().compareTo(o.toString());
        }

        public Locale getLocale() {
            return this.locale;
        }
    }
}

