/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.zip;

import ipsk.awt.ProgressWorker;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.io.FileUtils;
import ipsk.io.StreamCopy;
import ipsk.swing.JProgressDialogPanel;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class UnzipWorker
extends ProgressWorker {
    public static final boolean DEFAULT_LIMIT_TO_32BIT_SIZES = false;
    public static long MAX_32BIT_ZIP_FILE_SIZE = 0xFFFFFFFFL;
    public static int MAX_32BIT_ZIP_FILE_ENTRIES = 65536;
    public static int DEFAULT_BUF_SIZE = 32768;
    private int bufferSize = DEFAULT_BUF_SIZE;
    private long sizeDone = 0L;
    private File trgDir;
    private File sourceZipFile;
    private boolean limitTo32bitSizes;
    private boolean overwrite = false;
    private boolean trgDirCreated = false;

    @Override
    public void open() throws WorkerException {
        this.progressStatus.setLength(ProgressStatus.LENGTH_UNKNOWN);
        super.open();
    }

    public boolean isLimitTo32bitSizes() {
        return this.limitTo32bitSizes;
    }

    public void setLimitTo32bitSizes(boolean limitTo32bitSizes) {
        this.limitTo32bitSizes = limitTo32bitSizes;
    }

    @Override
    public void doWork() throws WorkerException {
        this.progressStatus.setMessage(new LocalizableMessage("Calculating ZIP archive size..."));
        long length = 0L;
        try {
            length = this.calcZipSize();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new WorkerException("Could not determine ZIP file size", e1);
        }
        this.progressStatus.setLength(length);
        this.fireProgressEvent();
        try {
            this.unpack();
        }
        catch (IOException e) {
            throw new WorkerException(e);
        }
    }

    private long calcZipSize() throws IOException {
        long totalSize = 0L;
        ZipFile zipFile = new ZipFile(this.sourceZipFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                if (this.hasCancelRequest()) {
                    this.progressStatus.setMessage(new LocalizableMessage("Canceled !"));
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    long l = -1L;
                    return l;
                }
                ZipEntry entry = entries.nextElement();
                long entrySize = entry.getSize();
                totalSize += entrySize;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return totalSize;
    }

    private void unpack() throws IOException {
        if (this.hasCancelRequest()) {
            this.progressStatus.setMessage(new LocalizableMessage("Canceled !"));
            return;
        }
        ZipFile zipFile = new ZipFile(this.sourceZipFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        if (!this.trgDir.exists()) {
            this.trgDirCreated = this.trgDir.mkdirs();
        }
        try {
            while (entries.hasMoreElements()) {
                File f;
                String name;
                ZipEntry entry;
                if (this.hasCancelRequest()) {
                    this.progressStatus.setMessage(new LocalizableMessage("Canceled !"));
                    zipFile.close();
                    if (!this.overwrite) {
                        if (this.trgDirCreated) {
                            FileUtils.deleteRecursive(this.trgDir);
                        } else {
                            zipFile = new ZipFile(this.sourceZipFile);
                            entries = zipFile.entries();
                            while (entries.hasMoreElements()) {
                                entry = entries.nextElement();
                                name = entry.getName();
                                f = new File(this.trgDir, name);
                                if (!f.exists()) continue;
                                if (entry.isDirectory() && f.isDirectory()) {
                                    FileUtils.deleteRecursive(f);
                                    continue;
                                }
                                f.delete();
                            }
                            zipFile.close();
                        }
                    }
                    return;
                }
                entry = entries.nextElement();
                name = entry.getName();
                f = new File(this.trgDir, name);
                this.progressStatus.setMessage(new LocalizableMessage("Unpack " + name + " ..."));
                this.fireProgressEvent();
                if (entry.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                File dir = f.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                long entrySize = entry.getSize();
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(f);
                StreamCopy.copy(is, (OutputStream)fos, this.bufferSize);
                this.sizeDone += entrySize;
                this.progressStatus.setProgress(this.sizeDone);
                this.fireProgressEvent();
            }
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            zipFile.close();
        }
    }

    public long getSizeDone() {
        return this.sizeDone;
    }

    public void setSizeDone(long sizeDone) {
        this.sizeDone = sizeDone;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public File getTrgDir() {
        return this.trgDir;
    }

    public void setTrgDir(File trgDir) {
        this.trgDir = trgDir;
    }

    public File getSourceZipFile() {
        return this.sourceZipFile;
    }

    public void setSourceZipFile(File sourceZipFile) {
        this.sourceZipFile = sourceZipFile;
    }

    public static void main(String[] args) {
        UnzipWorker unzipWorker = new UnzipWorker();
        unzipWorker.setSourceZipFile(new File(args[0]));
        unzipWorker.setTrgDir(new File(args[1]));
        JProgressDialogPanel progressDialog = new JProgressDialogPanel(unzipWorker, "Unzip test", "Unpacking...");
        try {
            unzipWorker.open();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        unzipWorker.start();
        JFrame f = new JFrame("Unzip test");
        Object val = progressDialog.showDialog(f);
        try {
            unzipWorker.close();
        }
        catch (WorkerException e) {
            e.printStackTrace();
        }
        Worker.State ws = unzipWorker.getStatus();
        if (!Worker.State.DONE.equals((Object)ws)) {
            if (Worker.State.CANCELLED.equals((Object)ws)) {
                JOptionPane.showMessageDialog(f, "Unzip canceled.");
                System.exit(1);
            } else {
                JOptionPane.showMessageDialog(f, "Unzip error!");
                System.exit(-1);
            }
        }
        System.exit(0);
    }
}

