/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.dsp;

public class LPC {
    public static double autocorr(double[] sig, int N, int i) {
        double v = 0.0;
        for (int n = 0; n < N; ++n) {
            v += sig[n] * sig[n + i];
        }
        return v;
    }

    public static double[] autocorr(double[] x, int n) {
        int N = x.length - 1;
        double[] r = new double[n + 1];
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j <= N - i; ++j) {
                int n2 = i;
                r[n2] = r[n2] + x[j] * x[j + i];
            }
        }
        return r;
    }

    public static double[] process(double[] x) {
        return LPC.process(x, x.length - 1);
    }

    public static double[] process(double[] x, int n) {
        double[] r = LPC.autocorr(x, n);
        return LPC.levinson(r, n);
    }

    public static double[] levinson(double[] r, int n) {
        double[] a_temp = new double[n + 1];
        double[] k = new double[n + 1];
        double[] a = new double[n + 1];
        k[0] = 0.0;
        a[0] = 1.0;
        a_temp[0] = 1.0;
        double alpha = r[0];
        for (int i = 1; i <= n; ++i) {
            int j;
            double epsilon = r[i];
            for (j = 1; j < i; ++j) {
                epsilon += a[j] * r[i - j];
            }
            a[i] = k[i] = -epsilon / alpha;
            alpha *= 1.0 - k[i] * k[i];
            for (j = 1; j < i; ++j) {
                a_temp[j] = a[j] + k[i] * a[i - j];
            }
            for (j = 1; j < i; ++j) {
                a[j] = a_temp[j];
            }
        }
        return a;
    }
}

