/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

public class DoubleRingBuffer {
    private double[] buffer;
    private int size = 0;
    long writePosition = 0L;
    long readPosition = 0L;

    public DoubleRingBuffer(int size) {
        this.buffer = new double[size];
        this.size = size;
    }

    public double[] getBuffer() {
        return this.buffer;
    }

    public int filled() {
        return (int)(this.writePosition - this.readPosition);
    }

    public int free() {
        return this.size - this.filled();
    }

    private int bufferPosition(long position) {
        return (int)(position % (long)this.size);
    }

    public int continuosAvailableToWrite() {
        int bufWritePosition = this.bufferWritePosition();
        int bufReadPosition = this.bufferReadPosition();
        if (bufReadPosition <= bufWritePosition) {
            return this.size - bufWritePosition;
        }
        return bufReadPosition - bufWritePosition;
    }

    public int bufferWritePosition() {
        return this.bufferPosition(this.writePosition);
    }

    public void written(int write) {
        this.writePosition += (long)write;
    }

    public int continuosAvailableToRead() {
        int bufWritePosition = this.bufferWritePosition();
        int bufReadPosition = this.bufferReadPosition();
        if (bufReadPosition <= bufWritePosition) {
            return bufWritePosition - bufReadPosition;
        }
        return this.size - bufReadPosition;
    }

    public int bufferReadPosition() {
        return this.bufferPosition(this.readPosition);
    }

    public void read(int read) {
        this.readPosition += (long)read;
    }

    public Double valueAtBufferPosition(int pos) {
        return this.buffer[pos];
    }

    public Double valueAtPosition(long position) {
        int bufPos = this.bufferPosition(position);
        return this.buffer[bufPos];
    }

    public Double read() {
        if (this.filled() <= 0) {
            return null;
        }
        int brp = this.bufferReadPosition();
        double val = this.buffer[brp];
        this.read(1);
        return val;
    }

    public void skip(long skip) {
        this.readPosition += skip;
    }

    public int getSize() {
        return this.size;
    }

    public long getWritePosition() {
        return this.writePosition;
    }

    public long getReadPosition() {
        return this.readPosition;
    }
}

