/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.apps.ui;

import ipsk.swing.JDialogPanel;
import ipsk.util.apps.UpdateManagerConfig;
import ipsk.util.apps.descriptor.Change;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class JUpdateManagerConfigDialog
extends JDialogPanel {
    private static final long serialVersionUID = -6224628620119851642L;
    private UpdateManagerConfig config;
    private JCheckBox checkOnStartup;
    private JComboBox<Change.Priority> notificationPriorityBox;

    public UpdateManagerConfig getConfig() {
        return this.config;
    }

    public void setConfig(UpdateManagerConfig config) {
        this.config = config;
        this.checkOnStartup.setSelected(config.isCheckOnStartup());
        this.notificationPriorityBox.setSelectedItem((Object)config.getInformOnUpdatePriority());
    }

    public void apply() {
        if (this.config != null) {
            this.config.setCheckOnStartup(this.checkOnStartup.isSelected());
            this.config.setInformOnUpdatePriority((Change.Priority)((Object)this.notificationPriorityBox.getSelectedItem()));
        }
    }

    public JUpdateManagerConfigDialog(String applicationName) {
        super(JDialogPanel.Options.OK);
        ResourceBundle rb = ResourceBundle.getBundle("ipsk.util.Messages");
        this.setFrameTitle(rb.getString("ipsk.util.apps.updatemanager.configuration.title"));
        this.config = new UpdateManagerConfig();
        Container co = this.getContentPane();
        co.setLayout(new GridBagLayout());
        GridBagConstraints lc = new GridBagConstraints();
        lc.insets = new Insets(2, 2, 2, 2);
        lc.gridx = 0;
        lc.gridy = 0;
        lc.fill = 2;
        JLabel checkOnStartUpLabel = new JLabel("Check for updates on startup:");
        co.add((Component)checkOnStartUpLabel, lc);
        this.checkOnStartup = new JCheckBox();
        ++lc.gridx;
        co.add((Component)this.checkOnStartup, lc);
        ++lc.gridy;
        lc.gridx = 0;
        co.add((Component)new JLabel("Notification priority level:"), lc);
        this.notificationPriorityBox = new JComboBox<Change.Priority>(Change.Priority.values());
        ++lc.gridx;
        co.add(this.notificationPriorityBox, lc);
        this.setConfig(this.config);
    }
}

