/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt.print;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.RepaintManager;

public class ComponentPrinter
implements Printable {
    private Component component;

    public ComponentPrinter(Component component) {
        this.component = component;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.component instanceof Printable) {
            return ((Printable)((Object)this.component)).print(g, pageFormat, pageIndex);
        }
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double printablewidth = pageFormat.getImageableWidth();
        double printableHeight = pageFormat.getImageableHeight();
        Dimension compDimension = this.component.getSize();
        double compWidth = compDimension.getWidth();
        double compHeight = compDimension.getHeight();
        double sx = printablewidth / compWidth;
        double sy = printableHeight / compHeight;
        double scale = Math.min(sx, sy);
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scale, scale);
        RepaintManager repaintManager = RepaintManager.currentManager(this.component);
        boolean doubleBuffered = repaintManager.isDoubleBufferingEnabled();
        repaintManager.setDoubleBufferingEnabled(false);
        g2d.transform(scaleTransform);
        this.component.print(g2d);
        repaintManager.setDoubleBufferingEnabled(doubleBuffered);
        return 0;
    }
}

