/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class FileFilterByExtension
extends FileFilter {
    private String description;
    private String baseDescription;
    protected Extension[] exts;
    private String[] extensions;

    public FileFilterByExtension() {
    }

    public FileFilterByExtension(String baseDescription, String[] extensions) {
        this.baseDescription = baseDescription;
        this.extensions = extensions;
        this.update();
    }

    public void setBaseDescription(String baseDescription) {
        this.baseDescription = baseDescription;
        this.update();
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
        this.update();
    }

    public void update() {
        StringBuffer descriptionSB = new StringBuffer(this.baseDescription);
        int extCount = this.extensions.length;
        this.exts = new Extension[extCount];
        if (extCount > 0) {
            descriptionSB.append(" (");
        }
        for (int i = 0; i < extCount; ++i) {
            String ext;
            this.exts[i] = new Extension();
            this.exts[i].extension = ext = this.extensions[i];
            int extLen = ext.length();
            StringBuffer extMatch = new StringBuffer(".*\\.");
            for (int c = 0; c < extLen; ++c) {
                extMatch.append('[');
                char extC = ext.charAt(c);
                char lcExtC = Character.toLowerCase(extC);
                char ucExtC = Character.toUpperCase(extC);
                extMatch.append(lcExtC);
                extMatch.append(ucExtC);
                extMatch.append(']');
            }
            extMatch.append('$');
            this.exts[i].extensionMatch = extMatch.toString();
            descriptionSB.append("*.");
            descriptionSB.append(ext);
            if (i >= extCount - 1) continue;
            descriptionSB.append(",");
        }
        if (extCount > 0) {
            descriptionSB.append(")");
        }
        this.description = descriptionSB.toString();
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String fName = f.getName();
        for (Extension e : this.exts) {
            if (!fName.matches(e.extensionMatch)) continue;
            return true;
        }
        return false;
    }

    public String extension(File f) {
        if (f.isDirectory()) {
            return null;
        }
        String fName = f.getName();
        for (Extension e : this.exts) {
            String extMatch = e.extensionMatch;
            if (!fName.matches(extMatch)) continue;
            return e.extension;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public class Extension {
        public String extension;
        public String extensionMatch;
    }
}

