/*
 * Decompiled with CFR 0.152.
 */
package ipsk.math.random;

import ipsk.io.FloatStream;
import ipsk.math.Complex;

public class GaussianDistributionRandomGenerator
implements FloatStream {
    public static final double DEFAULT_MEAN = 0.0;
    public static final double DEFAULT_VARIANCE = 1.0;
    private double mean;
    private double variance;
    private long pos = 0L;
    private Long length = null;
    private boolean closed = false;

    public GaussianDistributionRandomGenerator() {
        this(0.0, 1.0);
    }

    public GaussianDistributionRandomGenerator(double mean, double variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public GaussianDistributionRandomGenerator(double mean, double variance, long length) {
        this.mean = mean;
        this.variance = variance;
        this.length = length;
    }

    public GaussianDistributionRandomGenerator(long frameLength) {
        this(0.0, 1.0, frameLength);
    }

    public Complex generateGaussionDistributedValues() {
        double u2;
        double u1;
        double q;
        while ((q = (u1 = 2.0 * Math.random() - 1.0) * u1 + (u2 = 2.0 * Math.random() - 1.0) * u2) >= 1.0) {
        }
        double x = Math.sqrt(-2.0 * Math.log(q) / q) * u1;
        double y = Math.sqrt(-2.0 * Math.log(q) / q) * u2;
        double xmv = this.mean + Math.sqrt(this.variance) * x;
        double ymv = this.mean + Math.sqrt(this.variance) * y;
        return new Complex(xmv, ymv);
    }

    public void fillWithGaussionDistributedValues(double[] buf, int off, int len) {
        Complex doubleRandomValue;
        int i = 0;
        for (i = 0; i < len / 2; ++i) {
            doubleRandomValue = this.generateGaussionDistributedValues();
            int j = i * 2;
            buf[off + j] = doubleRandomValue.real;
            buf[off + j + 1] = doubleRandomValue.img;
        }
        if (len % 2 > 0) {
            doubleRandomValue = this.generateGaussionDistributedValues();
            buf[off + len - 1] = doubleRandomValue.real;
        }
    }

    @Override
    public int read(double[] buf, int offset, int len) {
        if (this.length != null) {
            if (this.pos >= this.length) {
                return -1;
            }
            if (this.pos + (long)len > this.length) {
                len = (int)(this.length - this.pos);
            }
        }
        this.fillWithGaussionDistributedValues(buf, offset, len);
        this.pos += (long)len;
        return len;
    }

    @Override
    public long skip(long skip) {
        return skip;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public static void main(String[] args) {
        GaussianDistributionRandomGenerator gdrg = new GaussianDistributionRandomGenerator();
        double sum = 0.0;
        for (int i = 1; i < 100000; ++i) {
            double v = gdrg.generateGaussionDistributedValues().real;
            double mean = (sum += v) / (double)i;
            System.out.println("Value: " + v + " Mean: " + mean);
        }
    }
}

