/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class TextRecordReader {
    private static int BUF_SIZE_INCREMENT = 100;
    private char[][] recordSeparators;
    private Reader sourceReader;
    private char[] buf = new char[1];
    private char[] recordBuf = new char[BUF_SIZE_INCREMENT];
    private int recordBufPos = 0;
    private char[] matchedChars;
    private int matchedCharsFilled = 0;

    public TextRecordReader(Reader sourceReader, char[][] recordSeparators) {
        this.recordSeparators = recordSeparators;
        this.sourceReader = sourceReader;
        int maxRecSeplen = 0;
        for (char[] recordSep : recordSeparators) {
            int recordSepLen = recordSep.length;
            if (recordSepLen <= maxRecSeplen) continue;
            maxRecSeplen = recordSepLen;
        }
        this.matchedChars = new char[maxRecSeplen];
    }

    private char[] createRecordBuf() {
        char[] resBuf = new char[this.recordBufPos];
        for (int i = 0; i < this.recordBufPos; ++i) {
            resBuf[i] = this.recordBuf[i];
        }
        this.recordBufPos = 0;
        return resBuf;
    }

    public char[] readRecord() throws IOException {
        while (this.sourceReader.read(this.buf) != -1) {
            for (char[] recordSep : this.recordSeparators) {
                int recordSepLen = recordSep.length;
                if (this.matchedCharsFilled >= recordSepLen) continue;
                boolean match = true;
                for (int i = 0; i < this.matchedCharsFilled; ++i) {
                    if (this.matchedChars[i] == recordSep[i]) continue;
                    match = false;
                    break;
                }
                if (!match || this.buf[0] != recordSep[this.matchedCharsFilled]) continue;
                this.matchedChars[this.matchedCharsFilled] = this.buf[0];
                ++this.matchedCharsFilled;
                if (this.matchedCharsFilled != recordSepLen) continue;
                this.matchedCharsFilled = 0;
                return this.createRecordBuf();
            }
            if (this.recordBuf.length <= this.recordBufPos + 1) {
                char[] newRecordBuf = new char[this.recordBufPos + BUF_SIZE_INCREMENT];
                for (int i = 0; i < this.recordBufPos; ++i) {
                    newRecordBuf[i] = this.recordBuf[i];
                }
                this.recordBuf = newRecordBuf;
            }
            this.recordBuf[this.recordBufPos] = this.buf[0];
            ++this.recordBufPos;
        }
        if (this.recordBufPos == 0) {
            return null;
        }
        return this.createRecordBuf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileReader testReader = null;
        try {
            testReader = new FileReader("/homes/klausj/TESTFILES/Tabellenimporttest.csv");
            TextRecordReader trr = new TextRecordReader(testReader, new char[][]{{'\r', '\n'}, {'\n'}, {'\r'}});
            char[] record = null;
            while ((record = trr.readRecord()) != null) {
                System.out.println("Record: " + new String(record));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (testReader != null) {
                try {
                    ((Reader)testReader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

