/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.dependency;

import ipsk.util.dependency.Dependent;
import ipsk.util.dependency.DependentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DependencyResolver<D extends Dependent<T>, T> {
    public boolean isResolvable(List<D> availDependents, D dependent) {
        HashSet availProvides = new HashSet();
        for (Dependent availDependent : availDependents) {
            availProvides.addAll(availDependent.getProvides());
        }
        dependent.getDependencies();
        boolean resolvable = availProvides.containsAll(dependent.getDependencies());
        return resolvable;
    }

    public List<D> resolve(Collection<D> dependents) {
        ArrayList<Dependent> unresolvedDsTmp;
        HashSet availProvides = new HashSet();
        ArrayList<Dependent> resolvedList = new ArrayList<Dependent>();
        ArrayList<Object> unresolvedDs = new ArrayList<D>(dependents);
        do {
            unresolvedDsTmp = new ArrayList<Dependent>();
            for (Dependent dependent : unresolvedDs) {
                List dDeps = dependent.getDependencies();
                boolean resolved = true;
                for (Object dDep : dDeps) {
                    if (availProvides.contains(dDep)) continue;
                    resolved = false;
                    break;
                }
                if (resolved) {
                    resolvedList.add(dependent);
                    availProvides.addAll(dependent.getProvides());
                    continue;
                }
                unresolvedDsTmp.add(dependent);
            }
        } while (unresolvedDsTmp.size() != unresolvedDs.size() && (unresolvedDs = unresolvedDsTmp).size() > 0);
        return resolvedList;
    }

    public static void main(String[] args) {
        ArrayList<DependentImpl<String>> deps = new ArrayList<DependentImpl<String>>();
        DependentImpl<String> d1 = new DependentImpl<String>(new String[]{"a"}, new String[0]);
        deps.add(d1);
        DependentImpl<String> d2 = new DependentImpl<String>(new String[]{"b", "c"}, new String[0]);
        deps.add(d2);
        DependentImpl<String> d3 = new DependentImpl<String>(new String[]{"c"}, new String[]{"a"});
        deps.add(d3);
        DependentImpl<String> d4 = new DependentImpl<String>(new String[0], new String[]{"c"});
        deps.add(d4);
        DependencyResolver dr = new DependencyResolver();
        List rDeps = dr.resolve(deps);
        for (Dependent rd : rDeps) {
            System.out.println(rd);
        }
    }
}

