/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.dsp;

import ips.dsp.IIRFilter;
import ipsk.io.FloatStream;
import java.io.IOException;

public class IIRFilterStream
extends IIRFilter
implements FloatStream {
    private FloatStream srcStream;
    private double[] buf;
    private int delayLen;

    public IIRFilterStream(FloatStream srcStream, double[] aCoeff, double[] bCoeff) {
        super(aCoeff, bCoeff);
        this.srcStream = srcStream;
        this.delayLen = aCoeff.length;
        if (bCoeff.length > this.delayLen) {
            this.delayLen = bCoeff.length;
        }
        this.buf = new double[this.delayLen];
    }

    @Override
    public int read(double[] buf, int offset, int len) throws IOException {
        int r;
        if (this.buf.length < len) {
            this.buf = new double[len];
        }
        if ((r = this.srcStream.read(this.buf, 0, len)) == -1) {
            return -1;
        }
        for (int i = 0; i < r; ++i) {
            buf[offset + i] = this.step(this.buf[i]);
        }
        return r;
    }

    @Override
    public long skip(long skip) throws IOException {
        long skipped = 0L;
        long saveSkipable = skip - (long)this.delayLen;
        if (saveSkipable > 0L) {
            return this.srcStream.skip(saveSkipable);
        }
        int toRead = (int)skip;
        int r = this.srcStream.read(this.buf, 0, toRead);
        if (r == -1) {
            return 0L;
        }
        skipped = r;
        for (int i = 0; i < r; ++i) {
            this.step(this.buf[i]);
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
        this.srcStream.close();
    }
}

