/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.VectorBuffer;
import ipsk.io.VectorBufferedOutputStream;
import java.io.InputStream;

public class VectorBufferedInputStream
extends InputStream {
    private byte[] currBuf = new byte[0];
    private int bufPos;
    private VectorBuffer buffers;
    private int vectorCount = 0;
    private int vectorCountMark = 0;
    private int offsetMark = 0;

    public VectorBufferedInputStream(VectorBuffer vb) {
        this.buffers = vb;
        if (this.buffers.size() > 0) {
            this.currBuf = this.buffers.get(this.vectorCount);
        }
    }

    public VectorBufferedInputStream(VectorBufferedOutputStream vbos) {
        this(vbos.getVectorBufferCopy());
    }

    @Override
    public synchronized int available() {
        if (this.bufPos < this.currBuf.length) {
            return this.currBuf.length - this.bufPos;
        }
        if (this.vectorCount + 1 >= this.buffers.size()) {
            return 0;
        }
        byte[] nextBuf = this.buffers.get(this.vectorCount + 1);
        return nextBuf.length;
    }

    @Override
    public void mark(int readlimit) {
        this.offsetMark = this.bufPos;
        this.vectorCountMark = this.vectorCount;
    }

    @Override
    public void reset() {
        this.bufPos = this.offsetMark;
        this.vectorCount = this.vectorCountMark;
        this.currBuf = this.buffers.get(this.vectorCount);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        if (this.bufPos >= this.currBuf.length) {
            ++this.vectorCount;
            if (this.vectorCount >= this.buffers.size()) {
                return -1;
            }
            this.currBuf = this.buffers.get(this.vectorCount);
            this.bufPos = 0;
        }
        return this.currBuf[this.bufPos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] buf, int offset, int len) {
        int toCopy;
        int bufAvail;
        if (this.bufPos >= this.currBuf.length) {
            ++this.vectorCount;
            if (this.vectorCount >= this.buffers.size()) {
                return -1;
            }
            this.currBuf = this.buffers.get(this.vectorCount);
            this.bufPos = 0;
        }
        if ((bufAvail = this.currBuf.length - this.bufPos) < (toCopy = len)) {
            toCopy = bufAvail;
        }
        System.arraycopy(this.currBuf, this.bufPos, buf, offset, toCopy);
        this.bufPos += toCopy;
        return toCopy;
    }

    @Override
    public synchronized long skip(long n) {
        long skipped = 0L;
        int currAvail = this.currBuf.length - this.bufPos;
        int currSkip = currAvail;
        if ((long)currSkip > n) {
            currSkip = (int)n;
        }
        skipped += (long)currSkip;
        this.bufPos += currSkip;
        if (this.bufPos == this.currBuf.length) {
            while (this.vectorCount + 1 < this.buffers.size() && skipped < n) {
                long toSkip = n - skipped;
                ++this.vectorCount;
                this.bufPos = 0;
                this.currBuf = this.buffers.get(this.vectorCount);
                if (toSkip > (long)this.currBuf.length) {
                    toSkip = this.currBuf.length;
                }
                this.bufPos = (int)((long)this.bufPos + toSkip);
                skipped += toSkip;
            }
        }
        return skipped;
    }
}

