/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.awt.AWTEventTransferAgent;
import ipsk.net.Upload;
import ipsk.net.UploadCacheListener;
import ipsk.net.UploadException;
import ipsk.net.event.UploadConnectionEvent;
import ipsk.net.event.UploadEvent;
import ipsk.net.event.UploadFinishedEvent;
import ipsk.net.event.UploadStateChangedEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.Logger;

public abstract class UploadCache
implements Runnable {
    public static final String DEF_CHECKSUM_ALGORITHM = "MD5";
    protected static boolean DEBUG = false;
    public static final int UNLIMITED = -1;
    protected static int ON_IDLE_DELAY = 2000;
    protected static int CONNECT_RETRY_DELAY = 10000;
    protected static int DEFAULT_CONNECT_RETRIES = 5;
    protected static int UPLOAD_RETRY_DELAY = 4000;
    protected static int UPLOAD_RETRIES = 20;
    protected static int DEBUG_DELAY = 0;
    protected static int DEFAULT_BUFSIZE = 2048;
    protected float byteRate = 0.0f;
    protected long connectedTimeInMillis = 0L;
    protected long totalUploadLength = 0L;
    protected boolean connected = false;
    protected boolean idle = true;
    protected boolean idleNotified = false;
    protected int bufSize;
    protected OutputStream outputStream;
    protected InputStream inputStream;
    protected byte[] buffer;
    protected URLConnection connection;
    protected String requestMethod;
    private Vector<Upload[]> uploadStreams = new Vector();
    protected Upload[] currentUpload = null;
    protected Upload currentStream = null;
    protected int currentStreamIndex = 0;
    protected boolean running = false;
    protected EventTransformer eventTransformer = new EventTransformer();
    private Thread uploadThread;
    protected long startConnect;
    protected long totalLength = 0L;
    protected long toUploadLength = 0L;
    protected long guessedToUploadLength = 0L;
    protected long holdLength = 0L;
    protected long holdSize = 0L;
    protected boolean synced = true;
    protected String responseMessage = new String("O.K.");
    private int responseCode = 0;
    protected int uploadRetryCount = 0;
    private String digestName = "MD5";
    private boolean overwrite = false;
    protected boolean transferRateLimitSupported = false;
    protected int transferRateLimit = -1;
    private Logger logger;

    public UploadCache() {
        this.bufSize = DEFAULT_BUFSIZE;
        this.buffer = new byte[this.bufSize];
        String packageName = this.getClass().getPackage().getName();
        this.logger = Logger.getLogger(packageName);
    }

    protected synchronized void calculateLength() {
        long toUploadLength = 0L;
        long holdLength = 0L;
        for (int i = 0; i < this.uploadStreams.size(); ++i) {
            Upload[] upload = this.uploadStreams.get(i);
            for (int j = 0; j < upload.length; ++j) {
                Upload uvb = upload[j];
                int status = uvb.getStatus();
                long len = uvb.getLength();
                if (status == 3 || status == 2 || status == -2) {
                    holdLength += len;
                    continue;
                }
                toUploadLength += len;
            }
        }
        this.toUploadLength = toUploadLength;
        this.holdLength = holdLength;
        this.totalLength = toUploadLength + holdLength;
        if (this.connectedTimeInMillis != 0L) {
            this.byteRate = (float)this.totalUploadLength / (float)this.connectedTimeInMillis;
        }
    }

    public synchronized void upload(Upload[] vbs) throws UploadException {
        int i;
        this.idle = false;
        this.idleNotified = false;
        if (this.digestName != null) {
            for (Upload upl : vbs) {
                upl.createChecksum(this.digestName);
            }
        }
        if (this.overwrite) {
            URL[] urls = new URL[vbs.length];
            for (i = 0; i < vbs.length; ++i) {
                urls[i] = vbs[i].getUrl();
            }
            Upload[] ubs = this.findMatch(urls);
            if (ubs != null) {
                this.uploadStreams.remove(ubs);
                if (ubs != this.currentUpload) {
                    for (int i2 = 0; i2 < ubs.length; ++i2) {
                        ubs[i2].setStatus(2);
                        this.logger.info("Upload " + ubs[i2] + " cancelled.");
                    }
                }
            }
        }
        boolean doneAvailable = true;
        while (this.holdLength > this.holdSize && doneAvailable) {
            doneAvailable = false;
            for (i = 0; i < this.uploadStreams.size(); ++i) {
                int j;
                Upload[] holds = this.uploadStreams.get(i);
                boolean done = true;
                int size = 0;
                for (j = 0; j < holds.length; ++j) {
                    size = (int)((long)size + holds[j].getLength());
                    if (holds[j].getStatus() == 3) continue;
                    done = false;
                    break;
                }
                if (!done) continue;
                this.uploadStreams.remove(holds);
                for (j = 0; j < holds.length; ++j) {
                    holds[j].delete();
                }
                this.holdLength -= (long)size;
                doneAvailable = true;
                if (!DEBUG) continue;
                System.out.println("Expired " + size + " bytes.");
            }
        }
        this.uploadStreams.add(vbs);
        this.calculateLength();
    }

    private synchronized Upload[] findMatch(URL[] urls) {
        Enumeration<Upload[]> e = this.uploadStreams.elements();
        block0: while (e.hasMoreElements()) {
            Upload[] uvbs = e.nextElement();
            if (uvbs.length != urls.length) continue;
            boolean match = true;
            for (int i = 0; i < uvbs.length; ++i) {
                if (!uvbs[i].getUrl().sameFile(urls[i])) {
                    match = false;
                    continue block0;
                }
                if (!match) continue;
                return uvbs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream[] getCachedInputStream(URL[] urls) throws UploadException {
        InputStream[] res = null;
        Upload[] us = this.findMatch(urls);
        if (us != null) {
            UploadCache uploadCache = this;
            synchronized (uploadCache) {
                res = new InputStream[us.length];
                for (int i = 0; i < us.length; ++i) {
                    res[i] = us[i].getInputStream();
                }
            }
        }
        return res;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        if (this.uploadThread == null || !this.uploadThread.isAlive()) {
            this.uploadThread = new Thread(this);
            this.uploadThread.setPriority(1);
            this.uploadThread.start();
        }
    }

    public void stop() {
        this.running = false;
        this.uploadThread.interrupt();
        try {
            this.uploadThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void getNextUpload() {
        this.currentStream = null;
        this.currentUpload = null;
        for (int i = 0; i < this.uploadStreams.size(); ++i) {
            Upload[] upload = this.uploadStreams.get(i);
            this.currentStreamIndex = 0;
            while (this.currentStreamIndex < upload.length) {
                int status = upload[this.currentStreamIndex].getStatus();
                if (status == 0 || status == -1) {
                    if (DEBUG) {
                        System.out.println("Found something to upload.");
                    }
                    this.currentUpload = upload;
                    this.currentStream = upload[this.currentStreamIndex];
                    this.idle = false;
                    return;
                }
                ++this.currentStreamIndex;
            }
        }
        this.idle = true;
    }

    @Override
    public abstract void run();

    public Upload getCurrentUploadStream() {
        return this.currentStream;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void clear() {
        this.uploadStreams.clear();
        this.uploadRetryCount = 0;
    }

    public void close() {
        this.stop();
        this.clear();
    }

    public synchronized void addUploadCacheListener(UploadCacheListener acl) {
        this.eventTransformer.addListener(acl);
    }

    public synchronized void removeUploadCacheListener(UploadCacheListener acl) {
        this.eventTransformer.removeListener(acl);
    }

    protected void fireConnected() {
        this.eventTransformer.fireAWTEventLater(new UploadConnectionEvent(this, UploadConnectionEvent.ConnectionState.CONNECTED));
    }

    protected void fireTryConnect() {
        this.eventTransformer.fireAWTEventLater(new UploadConnectionEvent(this, UploadConnectionEvent.ConnectionState.TRY_CONNECT));
    }

    protected void fireStateChanged(Upload uvb) {
        this.eventTransformer.fireAWTEventLater(new UploadStateChangedEvent(this, uvb));
    }

    protected void fireStateChangedWait(Upload uvb) {
        this.eventTransformer.fireAWTEventAndWait(new UploadStateChangedEvent(this, uvb));
    }

    protected void fireDisconnected() {
        this.eventTransformer.fireAWTEventLater(new UploadConnectionEvent(this, UploadConnectionEvent.ConnectionState.DISCONNECTED));
    }

    protected void fireFinished() {
        if (!this.idleNotified) {
            this.eventTransformer.fireAWTEventLater(new UploadFinishedEvent(this));
            this.idleNotified = true;
        }
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public long getTotalUploadLength() {
        return this.totalUploadLength;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public long getHoldSize() {
        return this.holdSize;
    }

    public void setHoldSize(long l) {
        this.holdSize = l;
    }

    public long getHoldLength() {
        return this.holdLength;
    }

    public float getByteRate() {
        return this.byteRate;
    }

    public long getToUploadLength() {
        return this.toUploadLength;
    }

    public long getGuessedToUploadLength() {
        if (this.synced) {
            return this.toUploadLength;
        }
        long now = System.currentTimeMillis();
        long uploadDuration = now - this.startConnect;
        return this.toUploadLength - (long)((float)uploadDuration * this.byteRate);
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String string) {
        this.requestMethod = string;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public int getTransferLimit() {
        return this.transferRateLimit;
    }

    public void setTransferLimit(int transferLimit) {
        this.transferRateLimit = transferLimit;
    }

    public boolean isTransferLimitSupported() {
        return this.transferRateLimitSupported;
    }

    public void setTransferLimitSupported(boolean transferLimitSupported) {
        this.transferRateLimitSupported = transferLimitSupported;
    }

    public class EventTransformer
    extends AWTEventTransferAgent<EventListener, EventObject> {
        @Override
        public void fireEvent(EventListener l, EventObject ev) {
            UploadCacheListener ucl = (UploadCacheListener)l;
            ucl.update((UploadEvent)ev);
        }
    }
}

