/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util;

import ipsk.awt.Worker;
import ipsk.util.LocalizableMessage;
import java.util.Date;

public class ProgressStatus
implements Cloneable {
    private Worker.State status = Worker.State.INIT;
    public static long LENGTH_UNKNOWN = -1L;
    private volatile boolean indeterminate = false;
    private volatile long progress = 0L;
    private long length = LENGTH_UNKNOWN;
    private volatile LocalizableMessage message = null;
    private volatile ProgressStatus subStatus = null;
    private volatile long subStatusLength;
    private volatile Date startTime = null;
    private volatile Date finishedTime = null;
    private volatile Date canceledTime = null;
    private volatile Date errorTime = null;

    public ProgressStatus() {
        this.length = 100L;
    }

    public ProgressStatus(boolean indeterminate, boolean finished, long progress) {
        this(indeterminate, finished, 100L, progress);
    }

    public ProgressStatus(boolean indeterminate, boolean finished, long length, long progress) {
        this.indeterminate = indeterminate;
        this.progress = progress;
        this.setLength(length);
    }

    public ProgressStatus(long progress) {
        this(false, false, progress);
    }

    public ProgressStatus(Object arg0, boolean finished) {
        this(false, finished, 0L);
    }

    public ProgressStatus(boolean finished, long progress) {
        this(false, finished, progress);
    }

    public ProgressStatus(long progress, LocalizableMessage message) {
        this(progress);
        this.message = message;
    }

    public synchronized ProgressStatus clone() {
        ProgressStatus clonedProgressStatus;
        try {
            clonedProgressStatus = (ProgressStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        clonedProgressStatus.message = this.message == null ? null : (LocalizableMessage)this.message.clone();
        if (this.subStatus != null) {
            clonedProgressStatus.subStatus = this.subStatus.clone();
        }
        if (this.startTime != null) {
            clonedProgressStatus.startTime = (Date)this.startTime.clone();
        }
        if (this.finishedTime != null) {
            clonedProgressStatus.finishedTime = (Date)this.finishedTime.clone();
        }
        if (this.canceledTime != null) {
            clonedProgressStatus.canceledTime = (Date)this.canceledTime.clone();
        }
        if (this.errorTime != null) {
            clonedProgressStatus.errorTime = (Date)this.errorTime.clone();
        }
        return clonedProgressStatus;
    }

    public void open() {
        this.status = Worker.State.OPEN;
    }

    public void start() {
        this.status = Worker.State.STARTED;
        this.startTime = new Date();
    }

    public void running() {
        this.status = Worker.State.RUNNING;
    }

    public void reset() {
        this.subStatus = null;
        this.indeterminate = false;
        this.setLength(this.length);
        this.progress = 0L;
        this.status = Worker.State.INIT;
        this.startTime = null;
        this.canceledTime = null;
        this.finishedTime = null;
        this.errorTime = null;
        this.message = null;
    }

    public long getProgress() {
        long progress = this.progress;
        if (this.subStatus != null) {
            long sLength = this.subStatus.getLength();
            long sProgress = this.subStatus.getProgress();
            progress += this.subStatusLength * sProgress / sLength;
        }
        return progress;
    }

    public Short getPercentProgress() {
        if (this.indeterminate) {
            return null;
        }
        if (this.length == 0L) {
            return (short)100;
        }
        long prPercent = this.getProgress() * 100L / this.length;
        return (short)prPercent;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public boolean isDone() {
        return Worker.State.DONE.equals((Object)this.status);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate = indeterminate;
    }

    public void setProgress(long progress) {
        this.progress = progress;
    }

    public synchronized void done() {
        if (this.length != LENGTH_UNKNOWN) {
            this.progress = this.length;
        }
        if (this.finishedTime == null) {
            this.finishedTime = new Date();
        }
        this.status = Worker.State.DONE;
    }

    public LocalizableMessage getMessage() {
        return this.message;
    }

    public void setMessage(LocalizableMessage message) {
        this.message = message;
    }

    public LocalizableMessage[] getMessages() {
        LocalizableMessage[] msgs;
        if (this.subStatus != null) {
            LocalizableMessage[] subMsgs = this.subStatus.getMessages();
            msgs = new LocalizableMessage[subMsgs.length + 1];
            msgs[0] = this.message;
            for (int i = 0; i < subMsgs.length; ++i) {
                msgs[i + 1] = subMsgs[i];
            }
        } else {
            msgs = new LocalizableMessage[]{this.message};
        }
        return msgs;
    }

    public ProgressStatus getSubStatus() {
        return this.subStatus;
    }

    public synchronized void setSubStatus(ProgressStatus subStatus, long subStatusLength) {
        this.subStatus = subStatus;
        this.subStatusLength = subStatusLength;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
        this.indeterminate = length == LENGTH_UNKNOWN;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public synchronized Long elapsedTimeMillis() {
        if (this.startTime != null) {
            if (this.errorTime != null) {
                return this.errorTime.getTime() - this.startTime.getTime();
            }
            if (this.canceledTime != null) {
                return this.canceledTime.getTime() - this.startTime.getTime();
            }
            if (this.finishedTime != null) {
                return this.finishedTime.getTime() - this.startTime.getTime();
            }
            return new Date().getTime() - this.startTime.getTime();
        }
        return null;
    }

    public synchronized Long estimatedFinishMillis() {
        if (this.length != LENGTH_UNKNOWN) {
            long progress = this.getProgress();
            Long elapsedMillis = this.elapsedTimeMillis();
            if (elapsedMillis != null && this.status.isActive() && progress != 0L) {
                return this.length * elapsedMillis / progress;
            }
        }
        return null;
    }

    public synchronized Date estimatedFinishTime() {
        Long estimatedFinishMillis;
        if (this.finishedTime != null) {
            return this.finishedTime;
        }
        if (this.status.isActive() && (estimatedFinishMillis = this.estimatedFinishMillis()) != null && this.startTime != null) {
            return new Date(this.startTime.getTime() + estimatedFinishMillis);
        }
        return null;
    }

    public synchronized void cancel() {
        if (this.status.isActive()) {
            this.status = Worker.State.CANCEL;
        }
    }

    public boolean hasCancelRequest() {
        return Worker.State.CANCEL.equals((Object)this.status);
    }

    public synchronized void canceled() {
        this.status = Worker.State.CANCELLED;
        if (this.canceledTime == null) {
            this.canceledTime = new Date();
        }
    }

    public boolean isCanceled() {
        return Worker.State.CANCELLED.equals((Object)this.status);
    }

    public boolean isError() {
        return Worker.State.ERROR.equals((Object)this.status);
    }

    public synchronized void error() {
        this.status = Worker.State.ERROR;
        if (this.errorTime == null) {
            this.errorTime = new Date();
        }
    }

    public synchronized void error(LocalizableMessage errorMsg) {
        this.message = errorMsg;
        this.error();
    }

    public Date getErrorTime() {
        return this.errorTime;
    }

    public Worker.State getStatus() {
        return this.status;
    }

    public String toString() {
        return this.status.toString() + " " + this.getPercentProgress() + " % done";
    }
}

