/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.text.ParserException;
import ipsk.text.StringTokenizer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MIMEType {
    public static final String TYPE_AUDIO = "audio";
    public static MIMEType TEXT_XML = new MIMEType("text", "xml", "xml");
    public static MIMEType APPLICATION_XML = new MIMEType("application", "xml", "xml");
    public static MIMEType APPLICATION_JSON = new MIMEType("application", "json", "json");
    public static MIMEType IMAGE_JPEG = new MIMEType("image", "jpg", "jpg");
    public static MIMEType IMAGE_PNG = new MIMEType("image", "png", "png");
    public static MIMEType IMAGE_GIF = new MIMEType("image", "gif", "gif");
    public static MIMEType IMAGE_TIFF = new MIMEType("image", "tiff", "tiff");
    public static MIMEType AUDIO_WAVE = new MIMEType("audio", "wav", "wav");
    public static MIMEType AUDIO_AIFF = new MIMEType("audio", "aiff", "aif");
    public static MIMEType VIDEO_WEBM = new MIMEType("video", "webm", "webm");
    private static MIMEType[] KNOWN_TYPES = new MIMEType[]{TEXT_XML, APPLICATION_XML, APPLICATION_JSON, IMAGE_JPEG, IMAGE_PNG, AUDIO_WAVE, AUDIO_AIFF, VIDEO_WEBM};
    private String type;
    private String subType;
    static String WILDCARD_TYPE = "*";
    private List<String> parameters = new ArrayList<String>();
    private String fileExtension = null;

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public MIMEType(String type, String subType, List<String> parameters, String fileExtension) {
        if (type == null) {
            throw new NullPointerException("Type cannot be null!");
        }
        this.type = type;
        this.subType = subType;
        this.parameters = parameters;
        this.fileExtension = fileExtension;
    }

    public MIMEType(String type, String subType, String fileExtension) {
        this(type, subType, new ArrayList<String>(), fileExtension);
    }

    private static MIMEType knownType(String type, String subType) {
        for (MIMEType knownType : KNOWN_TYPES) {
            if (!knownType.getType().equals(type) || !knownType.getSubType().equals(subType)) continue;
            return knownType;
        }
        return null;
    }

    public static MIMEType knownMimeTypeByFilename(String filename) {
        for (MIMEType kmt : KNOWN_TYPES) {
            if (!filename.toLowerCase(Locale.US).matches(".*[.]" + kmt.getFileExtension() + "$")) continue;
            return kmt;
        }
        return null;
    }

    public static MIMEType knownMimeTypeByPath(Path filePath) {
        Path fnamePath = filePath.getFileName();
        if (fnamePath != null) {
            return MIMEType.knownMimeTypeByFilename(fnamePath.toString());
        }
        return null;
    }

    public static MIMEType parse(String mimeTypeString) throws ParserException {
        MIMEType mimeType;
        String[] tokens = StringTokenizer.split(mimeTypeString, ';', true);
        if (tokens.length < 1) {
            throw new ParserException("Could not parse MIME type: " + mimeTypeString);
        }
        String[] splitStr = tokens[0].trim().split("\\s*/\\s*");
        if (splitStr == null) {
            throw new ParserException("Could not parse MIME type: " + mimeTypeString);
        }
        int splitStrCmps = splitStr.length;
        if (splitStrCmps < 1 || splitStrCmps > 2) {
            throw new ParserException("Could not parse MIME type: " + mimeTypeString);
        }
        String type = splitStr[0];
        String subType = null;
        if (splitStrCmps > 1) {
            subType = splitStr[1];
        }
        ArrayList<String> prms = new ArrayList<String>();
        for (int pi = 1; pi < tokens.length; ++pi) {
            prms.add(tokens[pi]);
        }
        MIMEType knownType = MIMEType.knownType(type, subType);
        if (knownType != null && prms.size() == 0) {
            mimeType = knownType;
        } else {
            String ext = null;
            if (knownType != null) {
                ext = knownType.getFileExtension();
            }
            mimeType = new MIMEType(type, subType, prms, ext);
        }
        return mimeType;
    }

    private boolean matchesType(String type, String otherType) {
        return WILDCARD_TYPE.equals(type) || WILDCARD_TYPE.equals(otherType) || type.equals(otherType);
    }

    private boolean matchesSubType(String subType, String otherSubType) {
        return subType == null || otherSubType == null || this.matchesType(subType, otherSubType);
    }

    public boolean matches(MIMEType otherMimeType) {
        return this.matchesType(this.type, otherMimeType.getType()) && this.matchesSubType(this.subType, otherMimeType.getSubType());
    }

    public boolean equals(Object other) {
        if (other instanceof MIMEType) {
            MIMEType otherMimeType = (MIMEType)other;
            boolean typeEq = this.type.equals(otherMimeType.getType());
            if (!typeEq) {
                return false;
            }
            String otherSubType = otherMimeType.getSubType();
            boolean subTypeEq = this.subType == null ? otherSubType == null : this.subType.equals(otherSubType);
            if (!subTypeEq) {
                return false;
            }
            boolean paramsEq = true;
            List<String> otherPrms = otherMimeType.getParameters();
            int prmsSize = this.parameters.size();
            if (prmsSize != otherPrms.size()) {
                return false;
            }
            for (int pi = 0; pi < prmsSize; ++pi) {
                String op;
                String p = this.parameters.get(pi);
                if (p.equals(op = otherPrms.get(pi))) continue;
                paramsEq = false;
                break;
            }
            return paramsEq;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public String toString() {
        String s = this.type;
        if (this.subType != null) {
            s = s.concat("/" + this.subType);
        }
        return s;
    }

    private int precedenceValue(MIMEType mime) {
        String subType;
        int val = 0;
        String type = mime.getType();
        if (!WILDCARD_TYPE.equals(type)) {
            val += 8;
        }
        if ((subType = mime.getSubType()) != null) {
            val += 2;
            if (!WILDCARD_TYPE.equals(subType)) {
                val += 4;
            }
        }
        return val;
    }

    public int precedenceCompare(MIMEType o) {
        return this.precedenceValue(this) - this.precedenceValue(o);
    }
}

