/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.text.xml;

import ipsk.swing.text.JTextPaneEditor;
import ipsk.swing.text.LinePosition;
import ipsk.swing.text.xml.XMLParserEvent;
import ipsk.swing.text.xml.XMLParserListener;
import ipsk.swing.text.xml.XMLParserThread;
import ipsk.xml.DOMConverterException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.StringReader;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class JXMLPaneEditor
extends JPanel
implements DocumentListener,
XMLParserListener {
    private JPanel validationPanel;
    private JLabel validLabel = new JLabel("Invalid");
    private JLabel posLabel = new JLabel("-:-");
    private JTextField messageLabel = new JTextField();
    private String systemId = null;
    private Document xmlSrcDoc;
    private XMLParserThread validator = null;
    private ThreadGroup validatorThreadGroup;
    private JTextPaneEditor textPaneEditor;
    private Vector<XMLParserListener> validationListeners = new Vector();

    public JXMLPaneEditor() {
        super(new BorderLayout());
        this.validatorThreadGroup = new ThreadGroup("XML Validators");
        this.textPaneEditor = new JTextPaneEditor();
        this.xmlSrcDoc = this.textPaneEditor.getDocument();
        this.xmlSrcDoc.addDocumentListener(this);
        this.messageLabel.setEditable(false);
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 2, 2);
        this.validationPanel = new JPanel(l);
        this.validationPanel.add((Component)this.validLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        ++c.gridx;
        this.validationPanel.add((Component)this.messageLabel, c);
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridx;
        this.validationPanel.add((Component)this.posLabel, c);
        this.add((Component)this.textPaneEditor, "Center");
        this.add((Component)this.validationPanel, "South");
        this.validateXml();
    }

    public void setText(String text) {
        this.xmlSrcDoc.removeDocumentListener(this);
        this.textPaneEditor.setText(text);
        this.validateXml();
        this.xmlSrcDoc.addDocumentListener(this);
    }

    public String getText() {
        return this.textPaneEditor.getText();
    }

    private synchronized void validateXml() {
        if (this.validator != null) {
            this.validator.removeListener(this);
            this.validator.interrupt();
        }
        InputSource is = new InputSource(new StringReader(this.textPaneEditor.getText()));
        if (this.systemId != null) {
            is.setSystemId(this.systemId);
        }
        try {
            this.validator = new XMLParserThread(this.validatorThreadGroup, is);
        }
        catch (DOMConverterException e) {
            this.validLabel.setText("Invalid");
            this.validLabel.setEnabled(true);
            this.validator = null;
            return;
        }
        this.validLabel.setEnabled(false);
        this.validator.addListener(this);
        this.validator.start();
    }

    @Override
    public synchronized void update(XMLParserEvent e) {
        Exception pe = e.getParseException();
        if (pe == null) {
            this.setXMLValid(true);
            this.posLabel.setText("");
            this.messageLabel.setText("OK");
            this.messageLabel.setToolTipText("XML parser validation OK");
        } else {
            Throwable peThr = pe.getCause();
            if (peThr instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)peThr;
                this.posLabel.setText(new LinePosition(spe.getLineNumber(), spe.getColumnNumber()).toString());
                this.messageLabel.setText(spe.getMessage());
                this.messageLabel.setToolTipText("XML parser (SAX) message: \n" + spe.getMessage());
            } else {
                this.posLabel.setText("-:-");
                this.messageLabel.setText(peThr.getLocalizedMessage());
                this.messageLabel.setToolTipText("DOM converter message: \n" + peThr.getLocalizedMessage());
            }
            this.setXMLValid(false);
        }
        this.validLabel.setEnabled(true);
        this.fireXMLValidatorUpdate(e);
    }

    protected void setXMLValid(boolean valid) {
        if (valid) {
            this.validLabel.setForeground(Color.GREEN);
            this.validLabel.setText("Valid");
        } else {
            this.validLabel.setForeground(Color.RED);
            this.validLabel.setText("Invalid");
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateXml();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateXml();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateXml();
    }

    public static void main(String[] args) {
        JXMLPaneEditor xmlPaneEditor = null;
        xmlPaneEditor = new JXMLPaneEditor();
        JFrame f = new JFrame();
        f.getContentPane().add(xmlPaneEditor);
        f.pack();
        f.setVisible(true);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public synchronized void addValidationListener(XMLParserListener l) {
        if (l != null && !this.validationListeners.contains(l)) {
            this.validationListeners.addElement(l);
        }
    }

    public synchronized void removeValidationListener(XMLParserListener l) {
        if (l != null) {
            this.validationListeners.removeElement(l);
        }
    }

    protected synchronized void fireXMLValidatorUpdate(XMLParserEvent event) {
        for (XMLParserListener listener : this.validationListeners) {
            listener.update(event);
        }
    }
}

