/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.FramedEditingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InterleavedChannelRoutingInputStream
extends FramedEditingInputStream {
    public static final boolean DEBUG = false;
    private Integer[] assignment;
    private volatile byte[] isBuf;
    private int sampleSize;
    private int frameRead = 0;

    public InterleavedChannelRoutingInputStream(InputStream is, int sampleSize, int inputChannelCount, Integer[] assignment) {
        super(is, sampleSize * inputChannelCount);
        this.sampleSize = sampleSize;
        if (inputChannelCount < 0) {
            throw new IllegalArgumentException("Negative channel count for input stream: " + inputChannelCount);
        }
        this.assignment = assignment;
        this.frameRead = assignment.length * sampleSize;
        this.isBuf = new byte[4096];
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        int read;
        if (len % this.frameRead > 0) {
            throw this.frameSizeException;
        }
        int framesToRead = len / this.frameRead;
        int bytesToRead = framesToRead * this.frameSize;
        if (bytesToRead > this.isBuf.length) {
            framesToRead = this.isBuf.length / this.frameSize;
            bytesToRead = framesToRead * this.frameSize;
        }
        if ((read = this.is.read(this.isBuf, 0, bytesToRead)) <= 0) {
            return read;
        }
        if (read % this.frameSize > 0) {
            throw this.frameSizeException;
        }
        int framesRead = read / this.frameSize;
        for (int i = 0; i < framesRead; ++i) {
            int trgFPos = offset + i * this.frameRead;
            int srcFPos = i * this.frameSize;
            for (int ch = 0; ch < this.assignment.length; ++ch) {
                Integer pc = this.assignment[ch];
                for (int sb = 0; sb < this.sampleSize; ++sb) {
                    int trgBufPos = trgFPos + ch * this.sampleSize + sb;
                    if (pc == null) {
                        buf[trgBufPos] = 0;
                        continue;
                    }
                    int srcBufPos = srcFPos + pc * this.sampleSize + sb;
                    buf[trgBufPos] = this.isBuf[srcBufPos];
                }
            }
        }
        return framesRead * this.frameRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n % (long)this.frameRead > 0L) {
            throw this.frameSizeException;
        }
        long framesToSkip = n / (long)this.frameRead;
        long toSkip = framesToSkip * (long)this.frameSize;
        long skipped = this.is.skip(toSkip);
        if (skipped % (long)this.frameSize > 0L) {
            throw this.frameSizeException;
        }
        long ret = skipped / (long)this.frameSize * (long)this.frameRead;
        return ret;
    }

    @Override
    public int available() throws IOException {
        int srcAvail = this.is.available();
        int avail = srcAvail * this.frameSize / this.frameRead;
        return avail;
    }
}

