/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.text.html.HTMLTextEncoder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class EditableURI {
    private String uri;
    private String encoding;

    public EditableURI(String uri) {
        this(uri, "UTF-8");
    }

    public EditableURI(String uri, String encoding) {
        this.uri = uri;
        this.encoding = encoding;
    }

    public String appendQueryMap(Map<String, String[]> queryMap) throws UnsupportedEncodingException {
        StringBuffer newUri = new StringBuffer(this.uri);
        if (newUri.indexOf("?") == -1) {
            newUri.append("?");
        }
        for (Map.Entry<String, String[]> me : queryMap.entrySet()) {
            String[] values;
            String key = me.getKey();
            for (String val : values = me.getValue()) {
                String lastChar = newUri.substring(newUri.length() - 1);
                if (!lastChar.equals("&") && !lastChar.equals("?")) {
                    newUri.append("&");
                }
                newUri.append(URLEncoder.encode(key, this.encoding) + "=" + URLEncoder.encode(val, this.encoding));
            }
        }
        this.uri = newUri.toString();
        return this.uri;
    }

    public String appendQuery(String key, Object value) throws UnsupportedEncodingException {
        StringBuffer newUri = new StringBuffer(this.uri);
        if (newUri.indexOf("?") == -1) {
            newUri.append("?");
        } else if (!newUri.substring(newUri.length() - 1).equals("&")) {
            newUri.append("&");
        }
        newUri.append(URLEncoder.encode(key, this.encoding) + "=" + URLEncoder.encode(value.toString(), this.encoding));
        this.uri = newUri.toString();
        return this.uri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getHTMLEncodedUri() {
        return HTMLTextEncoder.encode(this.uri);
    }

    public String toString() {
        return this.uri;
    }

    public Object clone() {
        return new EditableURI(this.uri, this.encoding);
    }
}

