/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.net.Upload;
import ipsk.net.UploadException;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

public class UploadFile
extends Upload
implements Serializable {
    static final long serialVersionUID = 7573125662518988131L;
    protected File file;

    public UploadFile() {
        this.file = null;
    }

    public UploadFile(File vb, URL url) {
        super(url);
        this.file = vb;
        this.status = 0;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File f) {
        this.file = f;
    }

    @Override
    public InputStream getInputStream() throws UploadException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new UploadException(e);
        }
    }

    @Override
    public long getLength() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.length();
    }

    @Override
    public void delete() {
        this.file.delete();
    }

    public synchronized Object clone() {
        UploadFile newObj = new UploadFile(this.file, this.url);
        newObj.name = this.name;
        newObj.comment = this.comment;
        newObj.status = this.status;
        return newObj;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int fileHC = null == this.file ? 0 : this.file.hashCode();
        hash = 31 * hash + fileHC;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        UploadFile uploadFile;
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return obj instanceof UploadFile && (uploadFile = (UploadFile)obj).getFile().equals(this.file) && super.equals(obj);
    }

    public static void main(String[] args) {
        try {
            UploadFile t1 = new UploadFile(new File("cache_a.wav"), new URL("http://localhost:80/a1.wav"));
            System.out.println("T1: " + t1.hashCode());
            UploadFile t2 = new UploadFile(new File("cache_a2.wav"), new URL("http://localhost:80/a1.wav"));
            System.out.println("T2: " + t2.hashCode());
            UploadFile t3 = new UploadFile(new File("cache_a.wav"), new URL("http://127.0.0.1/a1.wav"));
            System.out.println("T3: " + t3.hashCode());
            System.out.println("T1==T2 ?: " + t1.equals(t2));
            System.out.println("T2==T3 ?: " + t2.equals(t3));
            System.out.println("T1==T3 ?: " + t1.equals(t3));
            XMLEncoder xmlEnc = new XMLEncoder(new FileOutputStream("Test.xml"));
            xmlEnc.writeObject(t1);
            xmlEnc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

