/*
 * Decompiled with CFR 0.152.
 */
package ipsk.sql;

import ipsk.text.StringSequenceBuilder;
import java.util.List;

public class GroupByClause {
    private List<String> columns;

    public GroupByClause(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public String toSQLString() {
        if (this.columns == null || this.columns.size() == 0) {
            return "";
        }
        String groupByStr = " GROUP BY ";
        String colsStr = StringSequenceBuilder.buildString(this.columns, ',');
        return groupByStr + colsStr;
    }

    public String toJPQLString(String jpqlSelectExpression) {
        if (this.columns == null || this.columns.size() == 0) {
            return "";
        }
        String groupByStr = " GROUP BY ";
        int colsSize = this.columns.size();
        for (int i = 0; i < colsSize; ++i) {
            String column = this.columns.get(i);
            groupByStr = groupByStr.concat(jpqlSelectExpression + "." + column);
            if (i >= colsSize - 1) continue;
            groupByStr = groupByStr.concat(", ");
        }
        return groupByStr;
    }
}

