/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.awt.GridTick;
import ipsk.awt.JScale;
import ipsk.awt.TickProvider;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class JAutoScale
extends JScale<Long>
implements TickProvider<Long> {
    private final boolean DEBUG = false;
    private static final double DEFAULT_BASE = 10.0;
    private static final int[] DEFAULT_DIVIDERS = new int[]{2, 5};
    private static final double DEFAULT_AXIS_PADDING_FACTOR = 1.2;
    private static final double DEFAULT_NOAXIS_PADDING_FACTOR = 1.1;
    private int width;
    private int height;
    private int minWidth = 0;
    private int minHeight = 0;
    private double horizontalPaddingFactor;
    private double verticalPaddingFactor;
    private double paddedLabelWidth;
    private double paddedLabelHeight;
    private Format labelFormat;
    private int lineLength;
    private int halfLineLength;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private long scaleBegin;
    private long scaleEnd;
    private long delta;
    private double base;
    private int[] dividers;
    private Dimension maxLabelSize = new Dimension();
    private int maxNumTicks;
    private long majTick;
    private long firstTickValue;

    public JAutoScale() {
        this(JScale.Orientation.SOUTH, 0L, 0L);
    }

    public JAutoScale(JScale.Orientation orientation, long from, long to) {
        this(orientation, 0, from, to);
    }

    public JAutoScale(JScale.Orientation orientation, int length, long from, long to) {
        super(orientation);
        this.scaleBegin = from;
        this.scaleEnd = to;
        this.delta = to - from;
        this.base = 10.0;
        this.dividers = DEFAULT_DIVIDERS;
        if (JScale.Orientation.SOUTH.equals((Object)orientation)) {
            this.horizontalPaddingFactor = 1.2;
            this.verticalPaddingFactor = 1.1;
            this.minWidth = length;
        } else if (JScale.Orientation.WEST.equals((Object)orientation)) {
            this.horizontalPaddingFactor = 1.1;
            this.verticalPaddingFactor = 1.2;
            this.minHeight = length;
        }
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
        this.rescale();
    }

    private String format(long tickValue) {
        Long longObj = tickValue;
        if (this.labelFormat == null) {
            return longObj.toString();
        }
        return this.labelFormat.format(longObj);
    }

    private void computeTicks() {
        Dimension d = this.getSize();
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            this.maxNumTicks = (int)((double)d.width / this.paddedLabelWidth);
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            this.maxNumTicks = (int)((double)d.height / this.paddedLabelHeight);
        }
        double minTick = (double)this.delta / (double)this.maxNumTicks;
        double minTickAbs = Math.abs(minTick);
        double minTickPow = Math.log(minTickAbs) / Math.log(this.base);
        int tickPow = (int)Math.ceil(minTickPow);
        long majTickAbs = (long)Math.pow(this.base, tickPow);
        if (majTickAbs < 1L) {
            majTickAbs = 1L;
        }
        for (int i = 0; i < this.dividers.length; ++i) {
            if (!((double)(majTickAbs / (long)this.dividers[i]) > minTickAbs)) continue;
            majTickAbs /= (long)this.dividers[i];
        }
        this.majTick = this.delta >= 0L ? majTickAbs : -majTickAbs;
        if (majTickAbs > 0L) {
            long firstTickUnits = this.scaleBegin / majTickAbs;
            if (this.delta < 0L) {
                ++firstTickUnits;
            }
            this.firstTickValue = firstTickUnits * majTickAbs;
        } else {
            this.firstTickValue = this.scaleBegin;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        block9: {
            GridTick<Long>[] ticks;
            int lineX1;
            Rectangle a;
            block8: {
                GridTick<Long>[] ticks2;
                super.paintComponent(g);
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
                if (this.isEnabled()) {
                    g.setColor(this.getForeground());
                } else {
                    g.setColor(this.getBackground().darker());
                }
                a = g.getClipBounds();
                this.width = this.getWidth();
                this.height = this.getHeight();
                if (this.width == 0 || this.height == 0) {
                    return;
                }
                lineX1 = 0;
                int lineX2 = 0;
                int lineY1 = 0;
                int lineY2 = 0;
                if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
                    lineX1 = a.x;
                    lineX2 = a.x + a.width;
                    lineY2 = lineY1 = this.height - this.getMinimumSize().height;
                } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
                    lineX2 = lineX1 = this.getMinimumSize().width - 1;
                    lineY1 = a.y;
                    lineY2 = a.y + a.height;
                }
                g.setColor(this.getBackground());
                g.fillRect(lineX1, lineY1, this.width, this.height);
                g.setColor(this.getForeground());
                g.drawLine(lineX1, lineY1, lineX2, lineY2);
                if (!JScale.Orientation.SOUTH.equals((Object)this.orientation)) break block8;
                for (GridTick<Long> gt : ticks2 = this.getScaleTicks(a.x, a.x + a.width)) {
                    int pos = gt.getPosition();
                    g.drawString(this.format(gt.getTickValue()), pos + 1, lineY1 + this.maxLabelSize.height + this.halfLineLength);
                    g.drawLine(pos, 0, pos, lineY1 + this.lineLength);
                    int halfPos = pos + (gt.getNextPosition() - pos) / 2;
                    g.drawLine(halfPos, lineY1, halfPos, lineY1 + this.halfLineLength);
                }
                break block9;
            }
            if (!JScale.Orientation.WEST.equals((Object)this.orientation)) break block9;
            for (GridTick<Long> gt : ticks = this.getScaleTicks(a.y, a.y + a.height)) {
                int pos = gt.getPosition();
                g.drawString(this.format(gt.getTickValue()), lineX1 - this.maxLabelSize.width - this.halfLineLength, pos + this.maxLabelSize.height);
                g.drawLine(lineX1, pos, lineX1 - this.lineLength, pos);
                int halfPos = pos + (gt.getNextPosition() - pos) / 2;
                g.drawLine(lineX1, halfPos, lineX1 - this.halfLineLength, halfPos);
            }
        }
    }

    @Override
    public GridTick<Long>[] getScaleTicks(int fromPixel, int toPixel) {
        ArrayList<GridTick<Long>> gridTicks = new ArrayList<GridTick<Long>>();
        double dDelta = this.delta;
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            double dWidth = this.width;
            double dAx = fromPixel;
            long areaBegValue = this.scaleBegin + (long)(dAx * dDelta / dWidth);
            long tickValue = 0L;
            if (this.majTick != 0L) {
                tickValue = (areaBegValue - this.firstTickValue) / this.majTick * this.majTick + this.firstTickValue;
                long areaEndValue = this.scaleBegin + (long)((dAx + (double)(toPixel - fromPixel)) * dDelta / dWidth);
                do {
                    int pos = (int)((double)(tickValue - this.scaleBegin) / dDelta * dWidth);
                    int nextPos = (int)((double)(tickValue + this.majTick - this.scaleBegin) / dDelta * dWidth);
                    GridTick<Long> newTick = new GridTick<Long>(pos, tickValue);
                    newTick.setNextPosition(nextPos);
                    gridTicks.add(newTick);
                } while (this.majTick > 0L && (tickValue += this.majTick) <= areaEndValue || this.majTick < 0L && tickValue >= areaEndValue);
            }
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            double dHeight = this.height;
            double dAy = fromPixel;
            long areaBegValue = this.scaleBegin + (long)(dAy * dDelta / dHeight);
            long tickValue = 0L;
            if (this.majTick != 0L) {
                tickValue = (areaBegValue - this.firstTickValue) / this.majTick * this.majTick + this.firstTickValue;
                long areaEndValue = this.scaleBegin + (long)((dAy + (double)(toPixel - fromPixel)) * dDelta / dHeight);
                do {
                    int pos = (int)((double)(tickValue - this.scaleBegin) / dDelta * dHeight);
                    int nextPos = (int)(((double)(tickValue + this.majTick) - (double)this.scaleBegin) / dDelta * dHeight);
                    GridTick<Long> newTick = new GridTick<Long>(pos, tickValue);
                    newTick.setNextPosition(nextPos);
                    gridTicks.add(newTick);
                } while (this.majTick > 0L && (tickValue += this.majTick) <= areaEndValue || this.majTick < 0L && tickValue >= areaEndValue);
            }
        }
        GridTick[] emptyArray = new GridTick[]{};
        GridTick[] array = gridTicks.toArray(emptyArray);
        return array;
    }

    public double getVerticalPaddingFactor() {
        return this.verticalPaddingFactor;
    }

    public void setVerticalPaddingFactor(double d) {
        this.verticalPaddingFactor = d;
        this.rescale();
    }

    public double getHorizontalPaddingFactor() {
        return this.horizontalPaddingFactor;
    }

    public void setHorizontalPaddingFactor(double d) {
        this.horizontalPaddingFactor = d;
        this.rescale();
    }

    protected void calcMaxLabelSize() {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fontMetrics = this.getFontMetrics(f);
            Rectangle2D fromBounds = fontMetrics.getStringBounds(this.format(this.scaleBegin), this.getGraphics());
            Rectangle2D toBounds = fontMetrics.getStringBounds(this.format(this.scaleEnd), this.getGraphics());
            double fromWidth = fromBounds.getWidth();
            double toWidth = toBounds.getWidth();
            double fromHeight = fromBounds.getHeight();
            double toHeight = toBounds.getHeight();
            double maxLabelWidth = Math.max(fromWidth, toWidth);
            this.paddedLabelWidth = maxLabelWidth * this.horizontalPaddingFactor;
            double maxLabelHeight = Math.max(fromHeight, toHeight);
            this.paddedLabelHeight = maxLabelHeight * this.verticalPaddingFactor;
            Dimension d = new Dimension();
            d.setSize(maxLabelWidth, maxLabelHeight);
            this.maxLabelSize = d;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        this.calcMaxLabelSize();
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            this.lineLength = this.maxLabelSize.height;
            this.halfLineLength = this.lineLength / 2;
            this.minHeight = (int)this.paddedLabelHeight + 2 + this.halfLineLength;
            this.minWidth = 0;
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            this.lineLength = this.maxLabelSize.height;
            this.halfLineLength = this.lineLength / 2;
            this.minWidth = (int)this.paddedLabelWidth + 2 + this.halfLineLength;
            this.minHeight = 0;
        }
        return new Dimension(this.minWidth, this.minHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Format getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(Format format) {
        this.labelFormat = format;
        this.rescale();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.rescale();
    }

    private void rescale() {
        this.revalidate();
        this.repaint();
    }

    public long getScaleBegin() {
        return this.scaleBegin;
    }

    public void setScaleBegin(long scaleBegin) {
        this.scaleBegin = scaleBegin;
        this.rescale();
    }

    public long getScaleEnd() {
        return this.scaleEnd;
    }

    public void setScaleEnd(long scaleEnd) {
        this.scaleEnd = scaleEnd;
        this.rescale();
    }

    @Override
    public synchronized void setOrientation(JScale.Orientation orientation) {
        if (this.orientation.equals((Object)orientation)) {
            return;
        }
        super.setOrientation(orientation);
        int tmp1 = this.minWidth;
        this.minWidth = this.minHeight;
        this.minHeight = tmp1;
        double tmp2 = this.horizontalPaddingFactor;
        this.horizontalPaddingFactor = this.verticalPaddingFactor;
        this.verticalPaddingFactor = tmp2;
        this.rescale();
    }

    @Override
    public void doLayout() {
        this.delta = this.scaleEnd - this.scaleBegin;
        this.calcMaxLabelSize();
        this.computeTicks();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JAutoScale jasVer = new JAutoScale(JScale.Orientation.WEST, 800, 200L, 100L);
                JFrame testFrameVer = new JFrame(jasVer.getClass().getName() + " Test Vertical");
                testFrameVer.setDefaultCloseOperation(3);
                testFrameVer.getContentPane().add(jasVer);
                testFrameVer.pack();
                testFrameVer.setVisible(true);
            }
        });
    }

    public class Size
    extends Dimension2D {
        private double width;
        private double height;

        public Size(double width, double height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public void setSize(double arg0, double arg1) {
            this.width = arg0;
            this.height = arg1;
        }

        @Override
        public Object clone() {
            return new Size(this.width, this.height);
        }
    }
}

