/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

public class FileHandler
extends StreamHandler {
    protected File file;
    private Level DEFAULT_LEVEL = Level.ALL;
    private boolean autoflush = false;

    public FileHandler(File file, boolean append) throws SecurityException, FileNotFoundException {
        this.file = file;
        this.setOutputStream(new FileOutputStream(file, append));
        this.setLevel(this.DEFAULT_LEVEL);
    }

    public FileHandler(File file) throws SecurityException, FileNotFoundException {
        this(file, false);
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        if (this.autoflush) {
            this.flush();
        }
    }

    public File getFile() {
        return this.file;
    }

    public boolean isAutoflush() {
        return this.autoflush;
    }

    public void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }
}

