/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.optionparser;

import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParserException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class OptionParser
extends Vector<Option> {
    private String[] params;

    public void addOption(Option o) {
        this.add(o);
    }

    public void removeOption(Option o) {
        this.remove(o);
    }

    public void addOption(String opt) {
        this.add(new Option(opt));
    }

    public void addOption(String opt, String value) {
        this.add(new Option(opt, value));
    }

    public void parse(List<String> args) throws OptionParserException {
        this.parse(args.toArray(new String[args.size()]));
    }

    public void parse(String[] args) throws OptionParserException {
        int i;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            String optionChar = args[i].substring(1);
            if (optionChar.equals("-")) {
                ++i;
                break;
            }
            boolean found = false;
            Option opt = null;
            for (int j = 0; j < this.size(); ++j) {
                opt = (Option)this.elementAt(j);
                if (!optionChar.equals(opt.getOptionName())) continue;
                found = true;
                if (opt.hasParam()) {
                    if (++i == args.length) {
                        throw new OptionParserException("Missing parameter to option " + args[i - 1]);
                    }
                    opt.setParam(args[i]);
                    continue;
                }
                opt.setValue(true);
            }
            if (found) continue;
            throw new OptionParserException("Unknown option: " + args[i]);
        }
        int numParams = args.length - i;
        this.params = new String[numParams];
        for (int j = 0; j < numParams; ++j) {
            this.params[j] = args[i + j];
        }
    }

    public boolean isOptionSet(String opt) {
        Option o = this.getOption(opt);
        return o.isSet();
    }

    public Option getOption(String opt) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Option o = (Option)e.nextElement();
            if (!o.getOptionName().equals(opt)) continue;
            return o;
        }
        return null;
    }

    public String[] getParams() {
        return this.params;
    }

    public void setParams(String[] strings) {
        this.params = strings;
    }

    public Option[] getOptions() {
        return this.toArray(new Option[0]);
    }

    public static void main(String[] args) {
        OptionParser op = new OptionParser();
        op.addOption("v");
        op.addOption("a");
        op.addOption("t", "default_value");
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            e.printStackTrace();
        }
    }
}

