/*
 * Decompiled with CFR 0.152.
 */
package ipsk.awt;

import ipsk.awt.AWTEventTransferAgent;
import ipsk.awt.ProgressListener;
import ipsk.awt.Worker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressErrorEvent;
import ipsk.awt.event.ProgressEvent;
import ipsk.util.LocalizableMessage;
import ipsk.util.ProgressStatus;
import ipsk.util.ProgressUpdate;
import ipsk.util.Task;
import java.util.EventListener;
import java.util.EventObject;

public abstract class ProgressWorker
implements Worker,
ProgressUpdate,
Runnable {
    protected ProgressEventTransferAgent progressEventTransferAgent = new ProgressEventTransferAgent();
    protected String threadName;
    protected volatile boolean generateEvents = false;
    protected Thread thread;
    protected volatile ProgressStatus progressStatus;
    protected Task task = null;

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public ProgressWorker() {
        this(null);
    }

    public ProgressWorker(String threadName) {
        this.threadName = threadName;
        this.progressStatus = new ProgressStatus();
    }

    @Override
    public void fireProgressEvent() {
        if (this.generateEvents) {
            if (Worker.State.ERROR.equals((Object)this.progressStatus.getStatus())) {
                this.fireProgressEvent(new ProgressErrorEvent(this, this.progressStatus.clone()));
            } else {
                this.fireProgressEvent(new ProgressEvent(this, this.progressStatus.clone()));
            }
        }
    }

    protected void fireProgressEvent(ProgressEvent progressEvent) {
        this.progressEventTransferAgent.fireEvent(progressEvent);
    }

    @Override
    public void open() throws WorkerException {
        this.thread = this.threadName == null ? new Thread(this) : new Thread((Runnable)this, this.threadName);
        this.progressStatus.open();
        this.fireProgressEvent();
    }

    @Override
    public void start() {
        if (this.thread != null) {
            this.progressStatus.start();
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.progressStatus.running();
        try {
            this.doWork();
        }
        catch (WorkerException e) {
            ProgressStatus progressStatus = this.progressStatus;
            synchronized (progressStatus) {
                this.progressStatus.error(new LocalizableMessage(e.getMessage()));
                this.fireProgressEvent();
            }
        }
        ProgressStatus progressStatus = this.progressStatus;
        synchronized (progressStatus) {
            if (this.hasCancelRequest()) {
                this.progressStatus.canceled();
                this.fireProgressEvent();
            } else if (!this.progressStatus.isError()) {
                this.progressStatus.done();
                this.fireProgressEvent();
            }
        }
    }

    public void setRunningWithParentWorker() {
        this.progressStatus.running();
    }

    protected void doWork() throws WorkerException {
    }

    protected boolean hasCancelRequest() {
        return this.progressStatus.hasCancelRequest();
    }

    @Override
    public void cancel() {
        this.progressStatus.cancel();
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public Worker.State getStatus() {
        return this.progressStatus.getStatus();
    }

    public void reset() {
        this.thread = null;
        this.progressStatus.reset();
    }

    @Override
    public void close() throws WorkerException {
        this.cancel();
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new WorkerException(e);
        }
    }

    @Override
    public synchronized void addProgressListener(ProgressListener progressListener) {
        this.progressEventTransferAgent.addListener(progressListener);
        this.generateEvents = true;
    }

    @Override
    public synchronized void removeProgressListener(ProgressListener progressListener) {
        this.progressEventTransferAgent.removeListener(progressListener);
        this.generateEvents = this.progressEventTransferAgent.hasListeners();
    }

    @Override
    public ProgressStatus getProgressStatus() {
        return this.progressStatus;
    }

    public class ProgressEventTransferAgent
    extends AWTEventTransferAgent<EventListener, EventObject> {
        @Override
        public void fireEvent(EventListener l, EventObject ev) {
            ProgressListener pl = (ProgressListener)l;
            pl.update((ProgressEvent)ev);
        }
    }
}

