/*
 * Decompiled with CFR 0.152.
 */
package ipsk.beans;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyNameOrder {
    public static final String PROPERTY_NAME_WILDCARD = "*";
    private String[] availableProperties;
    private ArrayList<String> order = null;

    public boolean removeAll(Collection<String> c) {
        return this.order.removeAll(c);
    }

    public PropertyNameOrder(String[] availableProperties) {
        this.availableProperties = availableProperties;
    }

    public PropertyNameOrder(Set<String> availablePropertiesSet) {
        this(availablePropertiesSet.toArray(new String[0]));
    }

    public PropertyNameOrder(PropertyDescriptor[] persistencePropertyDescriptors) {
        this.availableProperties = new String[persistencePropertyDescriptors.length];
        for (int i = 0; i < persistencePropertyDescriptors.length; ++i) {
            this.availableProperties[i] = persistencePropertyDescriptors[i].getName();
        }
    }

    public String[] getOrder() {
        if (this.order == null) {
            return this.availableProperties;
        }
        return this.order.toArray(new String[0]);
    }

    public void applyPreferredOrder(String[] prefProperties) {
        if (prefProperties == null) {
            return;
        }
        ArrayList<String> newOrder = new ArrayList<String>();
        int asteriskInsertPoint = -1;
        List<String> availList = Arrays.asList(this.availableProperties);
        ArrayList<String> negatedProps = new ArrayList<String>();
        for (int i = 0; i < prefProperties.length; ++i) {
            String prefProp = prefProperties[i];
            if (prefProp.equals(PROPERTY_NAME_WILDCARD)) {
                asteriskInsertPoint = newOrder.size();
                continue;
            }
            if (prefProp.startsWith("!")) {
                String negatedProp = prefProp.replaceFirst("[!]\\s*", "");
                negatedProps.add(negatedProp);
                continue;
            }
            if (!availList.contains(prefProp)) continue;
            newOrder.add(prefProp);
        }
        if (asteriskInsertPoint >= 0) {
            String prefProp;
            int asteriskInsertPoint2 = -1;
            if (this.order != null) {
                for (int j = 0; j < this.order.size(); ++j) {
                    prefProp = this.order.get(j);
                    if (prefProp.equals(PROPERTY_NAME_WILDCARD)) {
                        asteriskInsertPoint = newOrder.size();
                        continue;
                    }
                    if (newOrder.contains(prefProp) || negatedProps.contains(prefProp)) continue;
                    newOrder.add(asteriskInsertPoint++, prefProp);
                }
                for (int k = 0; k < this.availableProperties.length; ++k) {
                    prefProp = this.availableProperties[k];
                    if (newOrder.contains(prefProp) || negatedProps.contains(prefProp)) continue;
                    if (asteriskInsertPoint2 >= 0) {
                        newOrder.add(asteriskInsertPoint2++, prefProp);
                        continue;
                    }
                    newOrder.add(prefProp);
                }
            } else {
                for (int k = 0; k < this.availableProperties.length; ++k) {
                    prefProp = this.availableProperties[k];
                    if (newOrder.contains(prefProp) || negatedProps.contains(prefProp)) continue;
                    newOrder.add(asteriskInsertPoint++, prefProp);
                }
            }
        }
        this.order = newOrder;
    }

    public void applyPreferredOrder(String prefPropertiesAsList) {
        if (prefPropertiesAsList == null) {
            return;
        }
        this.applyPreferredOrder(PropertyNameOrder.parsePropertyList(prefPropertiesAsList));
    }

    public static String[] parsePropertyList(String listAsString) {
        List<String> list = PropertyNameOrder.parsePropertyListAsList(listAsString);
        return list.toArray(new String[0]);
    }

    public static List<String> parsePropertyListAsList(String listAsString) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(listAsString, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken().trim());
        }
        return list;
    }

    public static void main(String[] args) {
        PropertyNameOrder pno = new PropertyNameOrder(new String[]{"aaa", "bbb", "ccc", "ddd", "eee"});
        pno.applyPreferredOrder("aaa,*,bbb");
        pno.applyPreferredOrder("eee,*");
        for (String o : pno.getOrder()) {
            System.out.println(o);
        }
    }

    public ArrayList<String> getOrderArrayList() {
        return this.order;
    }
}

