/*
 * Decompiled with CFR 0.152.
 */
package ipsk.io;

import ipsk.io.VectorBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class VectorBufferedOutputStream
extends OutputStream {
    public static final int DEFAULT_BUFSIZE = 2048;
    private byte[] currBuf;
    private VectorBuffer vectorBuffer;
    private int bufPos;
    private boolean closed;
    private int bufSize = 2048;

    public VectorBufferedOutputStream() {
        this(2048);
    }

    public VectorBufferedOutputStream(int bufSize) {
        this.bufSize = bufSize;
        this.currBuf = new byte[bufSize];
        this.bufPos = 0;
        this.vectorBuffer = new VectorBuffer();
        this.closed = false;
    }

    public synchronized VectorBuffer getVectorBufferCopy() {
        return (VectorBuffer)this.vectorBuffer.clone();
    }

    public synchronized VectorBuffer getVectorBuffer() {
        return this.vectorBuffer;
    }

    public synchronized long getLength() {
        if (this.closed) {
            return this.vectorBuffer.getLength();
        }
        return 0L;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.bufPos == this.bufSize) {
            this.bufPos = 0;
            this.vectorBuffer.add(this.currBuf);
            this.currBuf = new byte[this.bufSize];
        }
        this.currBuf[this.bufPos++] = (byte)(b & 0xFF);
    }

    @Override
    public synchronized void write(byte[] buf) {
        this.write(buf, 0, buf.length);
    }

    @Override
    public synchronized void write(byte[] buf, int offset, int len) {
        int toCopy;
        for (int copied = 0; copied < len; copied += toCopy) {
            int bufAvail;
            if (this.bufPos == this.bufSize) {
                this.bufPos = 0;
                this.vectorBuffer.add(this.currBuf);
                this.currBuf = new byte[this.bufSize];
            }
            if ((bufAvail = this.currBuf.length - this.bufPos) < (toCopy = len - copied)) {
                toCopy = bufAvail;
            }
            System.arraycopy(buf, offset + copied, this.currBuf, this.bufPos, toCopy);
            this.bufPos += toCopy;
        }
    }

    public int available() {
        if (this.bufPos < this.currBuf.length) {
            return this.currBuf.length - this.bufPos;
        }
        return this.bufSize;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.bufPos > 0) {
            byte[] lastBuf = new byte[this.bufPos];
            for (int i = 0; i < this.bufPos; ++i) {
                lastBuf[i] = this.currBuf[i];
            }
            this.vectorBuffer.add(lastBuf);
            this.bufPos = 0;
        }
        this.closed = true;
    }
}

