/*
 * Decompiled with CFR 0.152.
 */
package ipsk.sql;

public class OrderBy {
    private Type type = Type.PROPERTY;
    private String column;
    private boolean descending;

    public OrderBy(String column) {
        this(column, false);
    }

    public OrderBy(String column, boolean descending) {
        this(Type.PROPERTY, column, descending);
    }

    public OrderBy(Type type, String column, boolean descending) {
        this.type = type;
        this.column = column;
        this.descending = descending;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    public String toSQLString() {
        String directionStr = "";
        if (this.descending) {
            directionStr = " DESC";
        }
        Object orderStr = Type.SIZE_OFF_COLL_PROP.equals((Object)this.type) ? "count(" + this.column + ")" : this.column;
        return (String)orderStr + directionStr;
    }

    public String toJPQLString(String jpqlSelectExpression) {
        String directionStr = "";
        if (this.descending) {
            directionStr = " DESC";
        }
        String pathStr = jpqlSelectExpression + "." + this.column;
        String orderStr = Type.SIZE_OFF_COLL_PROP.equals((Object)this.type) ? "count(" + pathStr + ")" : pathStr;
        return orderStr + directionStr;
    }

    public static enum Type {
        PROPERTY,
        SIZE_OFF_COLL_PROP;

    }
}

