/*
 * Decompiled with CFR 0.152.
 */
package ipsk.sql;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class ResultSetEditor {
    private static boolean DEBUG = false;
    private int columnCount;
    private ResultSet resultSet;
    private ResultSetMetaData metaData;

    public ResultSetEditor(ResultSet resultSet) throws SQLException {
        this.resultSet = resultSet;
        this.metaData = resultSet.getMetaData();
        this.columnCount = this.metaData.getColumnCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBeanValues(Object bean) throws SQLException, IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BeanInfo bInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] propertyDescriptors = bInfo.getPropertyDescriptors();
        for (int i = 1; i <= this.columnCount; ++i) {
            String columnName = this.metaData.getColumnName(i);
            for (int j = 0; j < propertyDescriptors.length; ++j) {
                String propertyName = propertyDescriptors[j].getName();
                Class<?> propertyType = propertyDescriptors[j].getPropertyType();
                String propertyTypeName = propertyType.getName();
                Method writeMethod = propertyDescriptors[j].getWriteMethod();
                Object val = null;
                if (DEBUG) {
                    System.out.println("Set bean property: " + propertyName + " (" + propertyTypeName + ")");
                }
                if (!columnName.equals(propertyName)) continue;
                if (propertyType.isPrimitive()) {
                    if (propertyTypeName.equals("int")) {
                        val = this.resultSet.getInt(i);
                    } else {
                        if (!propertyTypeName.equals("boolean")) throw new SQLException("type " + propertyName + " not supported !");
                        val = this.resultSet.getBoolean(i);
                    }
                } else if (propertyTypeName.equals("java.lang.String")) {
                    val = this.resultSet.getString(i);
                } else if (propertyTypeName.equals("java.sql.Date")) {
                    val = this.resultSet.getDate(i);
                } else if (propertyTypeName.equals("java.sql.Timestamp")) {
                    val = this.resultSet.getTimestamp(i);
                } else {
                    if (!propertyTypeName.equals("java.util.Date")) throw new SQLException("type " + propertyName + " not supported !");
                    val = this.resultSet.getTimestamp(i);
                }
                if (val == null) continue;
                writeMethod.invoke(bean, val);
            }
        }
    }

    private void updateCurrentRow(Object bean) throws IntrospectionException, IllegalArgumentException, SQLException, IllegalAccessException, InvocationTargetException {
        BeanInfo bInfo = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] propertyDescriptors = bInfo.getPropertyDescriptors();
        for (int i = 1; i <= this.columnCount; ++i) {
            String columnName = this.metaData.getColumnName(i);
            for (int j = 0; j < propertyDescriptors.length; ++j) {
                String propertyName = propertyDescriptors[j].getName();
                Class<?> propertyType = propertyDescriptors[j].getPropertyType();
                String propertyTypeName = propertyType.getName();
                Method readMethod = propertyDescriptors[j].getReadMethod();
                if (!columnName.equals(propertyName)) continue;
                if (propertyType.isPrimitive()) {
                    if (propertyTypeName.equals("int")) {
                        int iVal = (Integer)readMethod.invoke(bean, new Object[0]);
                        if (DEBUG) {
                            System.out.println("Set: " + propertyName + " " + iVal);
                        }
                        this.resultSet.updateInt(i, iVal);
                        continue;
                    }
                    if (!propertyTypeName.equals("boolean")) continue;
                    boolean bVal = (Boolean)readMethod.invoke(bean, new Object[0]);
                    if (DEBUG) {
                        System.out.println("Set: " + propertyName + " " + bVal);
                    }
                    this.resultSet.updateBoolean(i, bVal);
                    continue;
                }
                if (propertyTypeName.equals("java.lang.String")) {
                    String val = (String)readMethod.invoke(bean, new Object[0]);
                    if (DEBUG) {
                        System.out.println("Set: " + propertyName + " " + val);
                    }
                    if (val == null) {
                        this.resultSet.updateNull(i);
                        continue;
                    }
                    this.resultSet.updateString(i, val);
                    continue;
                }
                if (propertyTypeName.equals("java.sql.Date")) {
                    java.sql.Date val = (java.sql.Date)readMethod.invoke(bean, new Object[0]);
                    if (DEBUG) {
                        System.out.println("Set: " + propertyName + " " + val);
                    }
                    if (val == null) {
                        this.resultSet.updateNull(i);
                        continue;
                    }
                    this.resultSet.updateDate(i, val);
                    continue;
                }
                if (propertyTypeName.equals("java.sql.Timestamp")) {
                    Timestamp val = (Timestamp)readMethod.invoke(bean, new Object[0]);
                    if (DEBUG) {
                        System.out.println("Set: " + propertyName + " " + val);
                    }
                    if (val == null) continue;
                    this.resultSet.updateTimestamp(i, val);
                    continue;
                }
                if (!propertyTypeName.equals("java.util.Date")) continue;
                Date val = (Date)readMethod.invoke(bean, new Object[0]);
                if (DEBUG) {
                    System.out.println("Set: " + propertyName + " " + val);
                }
                if (val == null) continue;
                this.resultSet.updateTimestamp(i, new Timestamp(val.getTime()));
            }
        }
    }

    public void updateRow(Object bean) throws IllegalArgumentException, IntrospectionException, SQLException, IllegalAccessException, InvocationTargetException {
        this.updateCurrentRow(bean);
        if (DEBUG) {
            System.out.println("Updating row: " + this.resultSet.getRow());
        }
        this.resultSet.updateRow();
    }

    public void insertBean(Object bean) throws IntrospectionException, IllegalArgumentException, SQLException, IllegalAccessException, InvocationTargetException {
        this.resultSet.moveToInsertRow();
        this.updateCurrentRow(bean);
        this.resultSet.insertRow();
    }
}

