/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.io.FileFilterByExtension;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class JImageFileWriter {
    public static void showFileStoreDialog(Component dialogParent, RenderedImage image) {
        block9: {
            try {
                String[] writerFileSuffixes = ImageIO.getWriterFileSuffixes();
                JFileChooser jfc = new JFileChooser();
                FileFilterByExtension pngFilter = new FileFilterByExtension("Image", writerFileSuffixes);
                jfc.setFileFilter(pngFilter);
                jfc.setFileSelectionMode(2);
                int returnVal = jfc.showSaveDialog(dialogParent);
                if (returnVal == 0) {
                    File file = jfc.getSelectedFile();
                    if (file.exists() && JOptionPane.showConfirmDialog(dialogParent, file.getName() + " exists. Do you want to overwrite ?", "Overwrite file ?", 0) != 0) {
                        return;
                    }
                    String selExtension = pngFilter.extension(file);
                    if (selExtension == null) {
                        JOptionPane.showMessageDialog(dialogParent, "Could not determine image file type by filename extension.", "Image writing error", 0);
                        return;
                    }
                    try {
                        Iterator<ImageWriter> wrs = ImageIO.getImageWritersBySuffix(selExtension);
                        if (!wrs.hasNext()) {
                            JOptionPane.showMessageDialog(dialogParent, "No image file writer found for extension: \"" + selExtension + "\"", "Image writing error", 0);
                            return;
                        }
                        ImageWriter iw = wrs.next();
                        FileImageOutputStream fios = new FileImageOutputStream(file);
                        iw.setOutput(fios);
                        iw.write(image);
                        iw.dispose();
                        break block9;
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(dialogParent, e.getLocalizedMessage(), "Image writing error", 0);
                        e.printStackTrace();
                        return;
                    }
                }
                if (returnVal == 1) {
                    JOptionPane.showMessageDialog(dialogParent, "Image save canceled", "Image writing cancel", 1);
                    return;
                }
                return;
            }
            catch (SecurityException se) {
                JOptionPane.showMessageDialog(dialogParent, se.getLocalizedMessage(), "Security error", 0);
            }
        }
    }
}

