/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing;

import ipsk.util.services.ServiceDescriptor;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ServicesTableModel
extends AbstractTableModel {
    public static final String[] COL_NAMES = new String[]{"Class", "Title", "Vendor", "Version"};
    private List<? extends ServiceDescriptor> serviceDescriptorList;

    @Override
    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        if (this.serviceDescriptorList != null) {
            return this.serviceDescriptorList.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int col) {
        if (this.serviceDescriptorList != null) {
            ServiceDescriptor sd;
            List<? extends ServiceDescriptor> list = this.serviceDescriptorList;
            synchronized (list) {
                int size = this.serviceDescriptorList.size();
                if (row >= size) {
                    return null;
                }
                sd = this.serviceDescriptorList.get(row);
            }
            if (col == 0) {
                return sd.getServiceImplementationClassname();
            }
            if (col == 1) {
                return sd.getTitle();
            }
            if (col == 2) {
                return sd.getVendor();
            }
            if (col == 3) {
                return sd.getImplementationVersion();
            }
        }
        return null;
    }

    public List<? extends ServiceDescriptor> getServiceDescriptorList() {
        return this.serviceDescriptorList;
    }

    public void setServiceDescriptorList(List<? extends ServiceDescriptor> serviceDescriptorList) {
        this.serviceDescriptorList = serviceDescriptorList;
        this.fireTableDataChanged();
    }
}

