/*
 * Decompiled with CFR 0.152.
 */
package ipsk.swing.scale;

import ipsk.awt.JScale;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.text.Format;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class JMinimalScale
extends JScale<BigDecimal> {
    private static final int DEBUG = 0;
    private static final int DEFAULT_LABEL_PADDING = 1;
    private BigDecimal[] tickList = new BigDecimal[2];
    private int labelPadding;
    private Format labelFormat;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private BigDecimal scaleBegin;
    private BigDecimal scaleEnd;
    private boolean normalizeLabelScales = true;

    public JMinimalScale() {
        this(JScale.Orientation.SOUTH, new BigDecimal(0), new BigDecimal(0));
    }

    public JMinimalScale(JScale.Orientation orientation, BigDecimal from, BigDecimal to) {
        this(orientation, null, from, to);
    }

    public JMinimalScale(JScale.Orientation orientation, String unit, BigDecimal d, BigDecimal e) {
        super(orientation);
        this.setLayout(null);
        this.labelPadding = 1;
        this.unit = unit;
        this.scaleBegin = d;
        this.scaleEnd = e;
    }

    private void _rescale(BigDecimal d, BigDecimal e) {
        if (this.normalizeLabelScales) {
            this.scaleBegin = d.stripTrailingZeros();
            this.scaleEnd = e.stripTrailingZeros();
        } else {
            this.scaleBegin = d;
            this.scaleEnd = e;
        }
    }

    private String format(BigDecimal tickValue) {
        return tickValue.toPlainString();
    }

    private String format(Number tickValue) {
        if (this.labelFormat == null) {
            return tickValue.toString();
        }
        return this.labelFormat.format(tickValue);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled()) {
            g.setColor(this.getForeground());
        } else {
            g.setColor(this.getBackground().darker());
        }
        Rectangle a = g.getClipBounds();
        Dimension size = this.getSize();
        int width = size.width;
        int height = size.height;
        if (width == 0 || height == 0) {
            return;
        }
        Dimension bs = new Dimension();
        if (this.scaleBegin != null) {
            bs = this.getLabelSize(this.scaleBegin);
        }
        Dimension us = new Dimension();
        if (this.unit != null) {
            us = this.getLabelSize(this.unit);
        }
        Dimension es = new Dimension();
        if (this.scaleEnd != null) {
            es = this.getLabelSize(this.scaleEnd);
        }
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            if (this.scaleBegin != null) {
                g.drawString(this.format(this.scaleBegin), this.labelPadding, this.labelPadding);
            }
            if (this.scaleEnd != null) {
                g.drawString(this.format(this.scaleEnd), width - this.labelPadding - es.width, this.labelPadding);
            }
        } else {
            if (this.scaleBegin != null) {
                g.drawString(this.format(this.scaleBegin), this.labelPadding, this.labelPadding + es.height);
            }
            if (this.unit != null) {
                g.drawString(this.unit, this.labelPadding, this.labelPadding + height / 2 + us.height / 2);
            }
            if (this.scaleEnd != null) {
                g.drawString(this.format(this.scaleEnd), this.labelPadding, height - this.labelPadding);
            }
        }
    }

    private Dimension getLabelSize(BigDecimal val) {
        return this.getLabelSize(this.format(val));
    }

    private Dimension getLabelSize(String label) {
        Font f = this.getFont();
        if (f != null) {
            FontMetrics fontMetrics = this.getFontMetrics(f);
            Rectangle2D valBounds = fontMetrics.getStringBounds(label, this.getGraphics());
            double valWidth = valBounds.getWidth();
            double valHeight = valBounds.getHeight();
            Dimension d = new Dimension();
            d.setSize(valWidth, valHeight);
            return d;
        }
        return new Dimension();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minimumSize = null;
        Dimension sb = new Dimension();
        if (this.scaleBegin != null) {
            sb = this.getLabelSize(this.scaleBegin);
        }
        Dimension su = new Dimension();
        if (this.unit != null) {
            su = this.getLabelSize(this.unit);
        }
        Dimension se = new Dimension();
        if (this.scaleEnd != null) {
            se = this.getLabelSize(this.scaleEnd);
        }
        double width = 0.0;
        double height = 0.0;
        if (JScale.Orientation.SOUTH.equals((Object)this.orientation)) {
            width = sb.getWidth() + su.getWidth() + se.getWidth() + (double)(4 * this.labelPadding);
            height = sb.getHeight();
            if (su.getHeight() > height) {
                height = su.getHeight();
            }
            if (se.getHeight() > height) {
                height = se.getHeight();
            }
            height += (double)(this.labelPadding * 2);
        } else if (JScale.Orientation.WEST.equals((Object)this.orientation)) {
            height = sb.getHeight() + su.getHeight() + se.getHeight() + (double)(4 * this.labelPadding);
            width = sb.getWidth();
            if (su.getWidth() > width) {
                width = su.getWidth();
            }
            if (se.getWidth() > width) {
                width = se.getWidth();
            }
            width += (double)(this.labelPadding * 2);
        }
        minimumSize = new Dimension((int)width, (int)height);
        return minimumSize;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Format getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(Format format) {
        this.labelFormat = format;
        this.rescale();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.rescale();
    }

    private void rescale() {
        this.revalidate();
        this.repaint();
    }

    public BigDecimal getScaleBegin() {
        return this.scaleBegin;
    }

    public void setScaleBegin(BigDecimal scaleBegin) {
        this.scaleBegin = scaleBegin;
        this.rescale();
    }

    public BigDecimal getScaleEnd() {
        return this.scaleEnd;
    }

    public void setScaleEnd(BigDecimal scaleEnd) {
        this.scaleEnd = scaleEnd;
        this.rescale();
    }

    @Override
    public synchronized void setOrientation(JScale.Orientation orientation) {
        if (this.orientation.equals((Object)orientation)) {
            return;
        }
        super.setOrientation(orientation);
        this.rescale();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMinimalScale jasVer = new JMinimalScale(JScale.Orientation.WEST, BigDecimal.valueOf(10000L, -1), BigDecimal.valueOf(500L, -1));
                jasVer.setUnit("db(A)");
                jasVer.setSize(100, 800);
                JFrame testFrameVer = new JFrame(jasVer.getClass().getName() + " Test Vertical");
                testFrameVer.setDefaultCloseOperation(3);
                testFrameVer.getContentPane().add(jasVer);
                testFrameVer.pack();
                testFrameVer.setVisible(true);
            }
        });
    }

    public class RenderModel {
        private Dimension size;
        private Dimension maxLabelSize = new Dimension();
        private int lineLength;
        private BigDecimal majTick;
        private BigDecimal majTickAbs;
        private List<BigDecimal> tickValueList;

        public Dimension getMaxLabelSize() {
            return this.maxLabelSize;
        }

        public void setMaxLabelSize(Dimension maxLabelSize) {
            this.maxLabelSize = maxLabelSize;
        }

        public int getLineLength() {
            return this.lineLength;
        }

        public void setLineLength(int lineLength) {
            this.lineLength = lineLength;
        }

        public List<BigDecimal> getTickValueList() {
            return this.tickValueList;
        }

        public void setTickValueList(List<BigDecimal> tickValueList) {
            this.tickValueList = tickValueList;
        }

        public void setMajTickAbs(BigDecimal majTickAbs) {
            this.majTickAbs = majTickAbs;
        }

        public void setSize(Dimension size) {
            this.size = size;
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setMajTick(BigDecimal majTick) {
            this.majTick = majTick;
        }

        public BigDecimal getMajTick() {
            return this.majTick;
        }

        public BigDecimal getMajTickAbs() {
            return this.majTickAbs;
        }
    }

    public class Size
    extends Dimension2D {
        private double width;
        private double height;

        public Size(double width, double height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public void setSize(double arg0, double arg1) {
            this.width = arg0;
            this.height = arg1;
        }

        @Override
        public Object clone() {
            return new Size(this.width, this.height);
        }
    }
}

