/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import ipsk.text.RFC3339TimeFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RFC3339DateTimeFormat
extends Format {
    public static final boolean DEFAULT_FIXED_LENGTH = true;
    private TemporalType temporalType = TemporalType.TIMESTAMP;
    private boolean fixedLength = true;
    private RFC3339TimeFormat timeFormat = new RFC3339TimeFormat();
    private DecimalFormat twoDigitFormatter = new DecimalFormat("00");
    private DecimalFormat fourDigitFormatter = new DecimalFormat("0000");
    private DecimalFormat milliSecFormatter = new DecimalFormat("###");
    private DecimalFormat fixedMilliSecFormatter = new DecimalFormat("000");

    public RFC3339DateTimeFormat() {
        this.twoDigitFormatter.setMaximumFractionDigits(0);
    }

    @Override
    public Object parseObject(String dateStr, ParsePosition parsePosition) {
        if (parsePosition == null) {
            throw new NullPointerException();
        }
        Calendar cal = Calendar.getInstance();
        if (this.temporalType.equals((Object)TemporalType.DATE)) {
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(15, 0);
        }
        cal.setTimeInMillis(0L);
        Number year = this.fourDigitFormatter.parse(dateStr, parsePosition);
        cal.set(1, year.intValue());
        if (dateStr.charAt(parsePosition.getIndex()) != '-') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Number month = this.twoDigitFormatter.parse(dateStr, parsePosition);
        cal.set(2, month.intValue() - 1);
        if (dateStr.charAt(parsePosition.getIndex()) != '-') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Number day = this.twoDigitFormatter.parse(dateStr, parsePosition);
        cal.set(5, day.intValue());
        if (this.temporalType.equals((Object)TemporalType.DATE)) {
            return cal.getTime();
        }
        if (dateStr.charAt(parsePosition.getIndex()) != 'T') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Number hour = this.twoDigitFormatter.parse(dateStr, parsePosition);
        cal.set(10, hour.intValue());
        if (dateStr.charAt(parsePosition.getIndex()) != ':') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Number minutes = this.twoDigitFormatter.parse(dateStr, parsePosition);
        cal.set(12, minutes.intValue());
        if (dateStr.charAt(parsePosition.getIndex()) != ':') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        int currPos = parsePosition.getIndex();
        ParsePosition secondsParsePo = new ParsePosition(0);
        String secondsStringwithoutFraction = dateStr.substring(currPos, currPos + 2);
        Number seconds = this.twoDigitFormatter.parse(secondsStringwithoutFraction, secondsParsePo);
        if (seconds == null) {
            parsePosition.setErrorIndex(parsePosition.getIndex() + secondsParsePo.getErrorIndex());
            return null;
        }
        cal.set(13, seconds.intValue());
        parsePosition.setIndex(parsePosition.getIndex() + 2);
        if (dateStr.charAt(parsePosition.getIndex()) == '.') {
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            Number mss = this.fixedLength ? (Number)this.fixedMilliSecFormatter.parse(dateStr, parsePosition) : (Number)this.milliSecFormatter.parse(dateStr, parsePosition);
            cal.set(14, mss.intValue());
        }
        if (dateStr.charAt(parsePosition.getIndex()) == 'Z') {
            boolean negative = false;
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            char maybePlusMinus = dateStr.charAt(parsePosition.getIndex());
            if (maybePlusMinus == '+') {
                parsePosition.setIndex(parsePosition.getIndex() + 1);
            } else {
                parsePosition.setIndex(parsePosition.getIndex() + 1);
                negative = true;
            }
            Number tzHours = this.twoDigitFormatter.parse(dateStr, parsePosition);
            if (dateStr.charAt(parsePosition.getIndex()) != ':') {
                parsePosition.setErrorIndex(parsePosition.getIndex());
                return null;
            }
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            Number tzMinutes = this.twoDigitFormatter.parse(dateStr, parsePosition);
            int tzMillis = (tzHours.intValue() * 60 + tzMinutes.intValue()) * 60 * 1000;
            if (negative) {
                tzMillis = -tzMillis;
            }
            cal.set(15, tzMillis);
        }
        return cal.getTime();
    }

    @Override
    public Object parseObject(String dateStr) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object parsedDate = this.parseObject(dateStr, parsePosition);
        if (parsedDate == null) {
            ParseException pe = new ParseException(dateStr, parsePosition.getErrorIndex());
            throw pe;
        }
        return parsedDate;
    }

    private void formatTime(long time, Calendar calendar, StringBuffer arg1) {
        int hour = calendar.get(11);
        arg1.append(this.twoDigitFormatter.format(hour));
        arg1.append(':');
        int min = calendar.get(12);
        arg1.append(this.twoDigitFormatter.format(min));
        arg1.append(':');
        int sec = calendar.get(13);
        arg1.append(this.twoDigitFormatter.format(sec));
        int msec = calendar.get(14);
        if (this.fixedLength) {
            arg1.append('.');
            arg1.append(this.fixedMilliSecFormatter.format(msec));
        } else if (msec > 0) {
            arg1.append('.');
            arg1.append(msec);
        }
        TimeZone tz = calendar.getTimeZone();
        int offset = tz.getOffset(time);
        if (this.fixedLength || offset != 0) {
            arg1.append('Z');
            int offsetMinutes = offset / 1000 / 60;
            int offsetHours = offsetMinutes / 60;
            int offsetRestMinutes = offsetMinutes % 60;
            if (this.fixedLength && offset >= 0) {
                arg1.append('+');
            }
            arg1.append(this.twoDigitFormatter.format(offsetHours));
            arg1.append(':');
            arg1.append(this.twoDigitFormatter.format(offsetRestMinutes));
        }
    }

    @Override
    public StringBuffer format(Object arg0, StringBuffer arg1, FieldPosition arg2) {
        if (arg0 == null) {
            throw new NullPointerException();
        }
        if (arg0 instanceof Long || arg0 instanceof Date) {
            long dateInMillis = arg0 instanceof Date ? ((Date)arg0).getTime() : ((Long)arg0).longValue();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(dateInMillis);
            int year = calendar.get(1);
            arg1.append(this.fourDigitFormatter.format(year));
            arg1.append('-');
            int month = calendar.get(2);
            arg1.append(this.twoDigitFormatter.format(month + 1));
            arg1.append('-');
            int day = calendar.get(5);
            arg1.append(this.twoDigitFormatter.format(day));
            if (this.temporalType.equals((Object)TemporalType.TIMESTAMP)) {
                arg1.append('T');
                this.formatTime(dateInMillis, calendar, arg1);
            }
            return arg1;
        }
        return null;
    }

    public static void main(String[] args) {
        RFC3339DateTimeFormat mtf = new RFC3339DateTimeFormat();
        Date date = new Date(0L);
        System.out.println(date);
        String result = mtf.format(date.getTime());
        System.out.println(result);
        try {
            Date parsedDate = (Date)mtf.parseObject(result);
            System.out.println(parsedDate);
            System.out.println(date.equals(parsedDate));
            System.out.println(date.getTime());
            System.out.println(parsedDate.getTime());
            System.out.println(date.getTime() == parsedDate.getTime());
            System.out.println(mtf.parseObject("1979-12-31T16:04:00.000Z+00:00"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date dateOnly = new Date();
        System.out.println(dateOnly);
        mtf.setTemporalType(TemporalType.DATE);
        result = mtf.format(dateOnly);
        System.out.println(result);
        try {
            Date dateOnlyParsed = (Date)mtf.parseObject(result);
            System.out.println(dateOnlyParsed);
            Date earlyTestdate = (Date)mtf.parseObject("1969-12-31");
            System.out.println(earlyTestdate.getTime());
            System.out.println(mtf.format(earlyTestdate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public TemporalType getTemporalType() {
        return this.temporalType;
    }

    public void setTemporalType(TemporalType temporalType) {
        this.temporalType = temporalType;
    }

    public static enum TemporalType {
        DATE,
        TIMESTAMP;

    }
}

