/*
 * Decompiled with CFR 0.152.
 */
package ipsk.text;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class RFC3339TimeFormat
extends Format {
    private static final long serialVersionUID = -3527064638540298773L;
    private DecimalFormat twoDigitFormatter = new DecimalFormat("00");
    private DecimalFormat secMilliSecFormatter;

    public RFC3339TimeFormat() {
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        if (nf instanceof DecimalFormat) {
            this.secMilliSecFormatter = (DecimalFormat)nf;
            StringBuffer doublePattern = new StringBuffer("00.###");
            this.secMilliSecFormatter.applyPattern(doublePattern.toString());
        }
    }

    private String toHourMinuteSecondMilliSecond(StringBuffer sb, double valInSeconds) {
        int minutes = (int)valInSeconds / 60;
        double seconds = valInSeconds - (double)minutes * 60.0;
        int hours = minutes / 60;
        sb.append(this.twoDigitFormatter.format(hours));
        sb.append(":");
        sb.append(this.twoDigitFormatter.format(minutes -= hours * 60));
        sb.append(':');
        sb.append(this.secMilliSecFormatter.format(seconds));
        return sb.toString();
    }

    private String toHourMinuteSecondMilliSecond(StringBuffer sb, long nanoseconds) {
        double seconds = (double)nanoseconds / 1.0E9;
        return this.toHourMinuteSecondMilliSecond(sb, seconds);
    }

    @Override
    public Object parseObject(String dateStr, ParsePosition parsePosition) {
        Number hour = this.twoDigitFormatter.parse(dateStr, parsePosition);
        if (dateStr.charAt(parsePosition.getIndex()) != ':') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Number minutes = this.twoDigitFormatter.parse(dateStr, parsePosition);
        if (dateStr.charAt(parsePosition.getIndex()) != ':') {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        parsePosition.setIndex(parsePosition.getIndex() + 1);
        Number seconds = this.secMilliSecFormatter.parse(dateStr, parsePosition);
        double res = hour.doubleValue() * 3600.0 + minutes.doubleValue() * 60.0 + seconds.doubleValue();
        return res;
    }

    @Override
    public StringBuffer format(Object arg0, StringBuffer arg1, FieldPosition arg2) {
        if (arg0 == null || arg2 == null) {
            throw new NullPointerException();
        }
        if (arg2.getField() != 0) {
            throw new IllegalArgumentException("Format of field position " + arg2 + " not supported.");
        }
        if (arg0 instanceof Integer) {
            int val = (Integer)arg0;
            this.toHourMinuteSecondMilliSecond(arg1, val);
            return arg1;
        }
        if (arg0 instanceof Long) {
            long val = (Long)arg0;
            this.toHourMinuteSecondMilliSecond(arg1, val);
            return arg1;
        }
        throw new IllegalArgumentException("Object type not supported.");
    }

    public static void main(String[] args) {
        RFC3339TimeFormat mtf = new RFC3339TimeFormat();
        Integer testSecondsValue = 2;
        testSecondsValue = Integer.MIN_VALUE;
        System.out.println(testSecondsValue);
        String result = mtf.format(testSecondsValue);
        System.out.println(result);
        try {
            System.out.println(mtf.parseObject(result));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

