/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlType;

@XmlType(name="i18n", namespace="http://www.phonetik.uni-muenchen.de/schema/util/i18n")
public class LocalizableMessage {
    private String resourceKey = null;
    private String resourceBundleName = null;
    private String standardMessage = null;
    private Map<Locale, String> localizedStringMap = null;
    private Object[] arguments = null;

    public Object[] getArguments() {
        return this.arguments;
    }

    public String getStandardMessage() {
        return this.standardMessage;
    }

    public LocalizableMessage(String standardMessage) {
        this.standardMessage = standardMessage;
    }

    public LocalizableMessage(Map<Locale, String> localizedStringMap) {
        this.localizedStringMap = localizedStringMap;
    }

    public LocalizableMessage(String resourceBundleName, String resourceKey) {
        this(resourceBundleName, resourceKey, null);
    }

    public LocalizableMessage(String resourceBundleName, String resourceKey, Object[] parameters) {
        if (resourceKey == null) {
            throw new IllegalArgumentException("Resource key must not be null");
        }
        this.resourceBundleName = resourceBundleName;
        this.resourceKey = resourceKey;
        this.arguments = parameters;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String localize() {
        return this.localize(null);
    }

    public String toString() {
        return this.localize();
    }

    public String localize(Locale locale) {
        if (this.standardMessage != null) {
            return this.standardMessage;
        }
        if (this.localizedStringMap != null) {
            String lStr;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if ((lStr = this.localizedStringMap.get(locale)) != null) {
                return lStr;
            }
            Locale noVariantLocale = new Locale(locale.getLanguage(), locale.getCountry());
            lStr = this.localizedStringMap.get(noVariantLocale);
            if (lStr != null) {
                return lStr;
            }
            Locale noCountryLocale = new Locale(locale.getLanguage());
            lStr = this.localizedStringMap.get(noCountryLocale);
            if (lStr != null) {
                return lStr;
            }
            lStr = this.localizedStringMap.get(null);
            if (lStr != null) {
                return lStr;
            }
            return null;
        }
        if (this.resourceBundleName != null) {
            ResourceBundle rb = locale != null ? ResourceBundle.getBundle(this.resourceBundleName, locale) : ResourceBundle.getBundle(this.resourceBundleName);
            String pattern = rb.getString(this.resourceKey);
            MessageFormat mf = locale != null ? new MessageFormat(pattern, locale) : new MessageFormat(pattern);
            Object[] args = new Object[]{};
            if (this.arguments != null) {
                args = this.arguments;
            }
            String msg = mf.format(args, new StringBuffer(), (FieldPosition)null).toString();
            return msg;
        }
        return null;
    }

    public Object clone() {
        if (this.standardMessage != null) {
            return new LocalizableMessage(this.standardMessage);
        }
        return new LocalizableMessage(this.resourceBundleName, this.resourceKey);
    }

    public static void main(String[] args) {
        HashMap<Locale, String> lStrs = new HashMap<Locale, String>();
        lStrs.put(null, "Hello (default)");
        lStrs.put(new Locale("de"), "Hallo");
        lStrs.put(new Locale("de", "DE"), "Hallo Deutschland");
        lStrs.put(new Locale("de", "AT"), "Hallo Oesterreich");
        lStrs.put(new Locale("en"), "Hello");
        LocalizableMessage lm = new LocalizableMessage(lStrs);
        System.out.println(lm.localize(new Locale("de")));
    }

    public Map<Locale, String> getLocalizedStringMap() {
        return this.localizedStringMap;
    }
}

