/*
 * Decompiled with CFR 0.152.
 */
package ipsk.util.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipPacker {
    private ZipOutputStream zipStream;
    private int bufSize = 2048;
    private byte[] buf;
    private long sizeDone = 0L;

    public ZipPacker(OutputStream outputStream) {
        this.zipStream = new ZipOutputStream(outputStream);
        this.buf = new byte[this.bufSize];
    }

    public String packDir(String dirName) throws IOException {
        String zipEntryName = new String(dirName);
        if (!zipEntryName.endsWith(File.separator)) {
            zipEntryName = zipEntryName.concat("/");
        } else {
            zipEntryName.replaceFirst(File.separator + "$", "/");
        }
        ZipEntry entry = new ZipEntry(zipEntryName);
        this.zipStream.putNextEntry(entry);
        this.zipStream.closeEntry();
        return zipEntryName;
    }

    public void packFile(File file, String zipEntryName) throws IOException {
        int read;
        FileInputStream fis = new FileInputStream(file);
        ZipEntry fe = new ZipEntry(zipEntryName);
        this.zipStream.putNextEntry(fe);
        while ((read = fis.read(this.buf)) != -1) {
            this.zipStream.write(this.buf, 0, read);
            this.sizeDone += (long)read;
        }
        this.zipStream.closeEntry();
        fis.close();
    }

    public void packStream(InputStream stream, String zipEntryName) throws IOException {
        int read;
        ZipEntry fe = new ZipEntry(zipEntryName);
        this.zipStream.putNextEntry(fe);
        while ((read = stream.read(this.buf)) != -1) {
            this.zipStream.write(this.buf, 0, read);
            this.sizeDone += (long)read;
        }
        this.zipStream.closeEntry();
        stream.close();
    }

    public void packData(byte[] data, String zipEntryName) throws IOException {
        this.packData(data, 0, data.length, zipEntryName);
    }

    public void packData(byte[] data, int off, int len, String zipEntryName) throws IOException {
        ZipEntry fe = new ZipEntry(zipEntryName);
        this.zipStream.putNextEntry(fe);
        this.zipStream.write(data, off, len);
        this.sizeDone += (long)len;
        this.zipStream.closeEntry();
    }

    public void packDirRecursive(File dir) throws IOException {
        this.packDirRecursive("", dir);
    }

    public long calcRawSize(File dir) {
        long size = 0L;
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                size += this.calcRawSize(f);
                continue;
            }
            size += f.length();
        }
        return size;
    }

    public void packDirRecursive(String base, File dir) throws IOException {
        Object dirName = base;
        if (!((String)dirName).equals("") && !((String)dirName).endsWith("/")) {
            dirName = (String)dirName + "/";
        }
        dirName = (String)dirName + dir.getName();
        this.packDir((String)dirName);
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.packDirRecursive((String)dirName, f);
                continue;
            }
            this.packFile(f, (String)dirName + "/" + f.getName());
        }
    }

    public long getSizeDone() {
        return this.sizeDone;
    }

    public void setSizeDone(long sizeDone) {
        this.sizeDone = sizeDone;
    }

    public void close() throws IOException {
        this.zipStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: " + ZipPacker.class.getName() + " zipFile srcDir");
        }
        File zip = new File(args[0]);
        ZipPacker zp = null;
        try {
            zp = new ZipPacker(new FileOutputStream(zip));
            zp.packDirRecursive(new File(args[1]));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                zp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

